% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.neuralGAM.R
\name{autoplot.neuralGAM}
\alias{autoplot.neuralGAM}
\title{Autoplot method for \code{neuralGAM} objects (epistemic-only)}
\usage{
\method{autoplot}{neuralGAM}(
  object,
  newdata = NULL,
  which = c("response", "link", "terms"),
  interval = c("none", "confidence"),
  level = 0.95,
  forward_passes = 150,
  term = NULL,
  rug = TRUE,
  ...
)
}
\arguments{
\item{object}{A fitted \code{neuralGAM} object.}

\item{newdata}{Optional \code{data.frame}/list of covariates. If omitted, training data are used.}

\item{which}{One of \code{c("response","link","terms")}. Default \code{"response"}.}

\item{interval}{One of \code{c("none","confidence")}. Default \code{"confidence"}.}

\item{level}{Coverage level for confidence intervals (e.g., \code{0.95}). Default \code{0.95}.}

\item{forward_passes}{Integer. Number of MC-dropout forward passes used when
\code{uncertainty_method \%in\% c("epistemic","both")}.}

\item{term}{Single term name to plot when \code{which = "terms"}.}

\item{rug}{Logical; if \code{TRUE} (default), add rugs to continuous term plots.}

\item{...}{Additional arguments passed to \code{predict.neuralGAM}.}
}
\value{
A single \code{ggplot} object.
}
\description{
Produce effect/diagnostic plots from a fitted \code{neuralGAM} model.
Supported panels:
\itemize{
\item \code{which = "response"}: fitted response vs. index, with optional
epistemic \emph{confidence intervals} (CI).
\item \code{which = "link"}: linear predictor (link scale) vs. index,
with optional CI.
\item \code{which = "terms"}: single per-term contribution \eqn{g_j(x_j)} on the link scale,
with optional CI band for the smooth (epistemic).
}
}
\details{
\strong{Uncertainty semantics (epistemic only)}
\itemize{
\item \strong{CI:} Uncertainty about the fitted mean.
\item For the response, SEs are mapped via the delta method;
\item For terms, bands are obtained as \eqn{\hat g_j \pm z \cdot SE(\hat g_j)} on the link scale.
}
}
\examples{
\dontrun{

library(neuralGAM)
dat <- sim_neuralGAM_data()
train <- dat$train
test  <- dat$test

ngam <- neuralGAM(
  y ~ s(x1) + x2 + s(x3),
  data = train, family = "gaussian", num_units = 128,
  uncertainty_method = "epistemic", forward_passes = 10
)
## --- Autoplot (epistemic-only) ---
# Per-term effect with CI band
autoplot(ngam, which = "terms", term = "x1", interval = "confidence")  +
  ggplot2::xlab("x1") + ggplot2::ylab("Partial effect")

# Request a different number of forward passes or CI level:
autoplot(ngam, which = "terms", term = "x1", interval = "confidence",
forward_passes = 15, level = 0.7)
# Response panel
autoplot(ngam, which = "response")

# Link panel with custom title
autoplot(ngam, which = "link")  +
  ggplot2::ggtitle("Main Title")

}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo
}
