% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netHTML_2_arrows.R
\name{netHTML2arrows}
\alias{netHTML2arrows}
\title{Generate Network Maze (2 arrows)}
\usage{
netHTML2arrows(nodeLogic = NULL, wd = NULL, names = NULL)
}
\arguments{
\item{nodeLogic}{This is the connections between the nodes.}

\item{wd}{is the working directory to save the HTML source code in. If not given, the file will be saved in the default working directory.}

\item{names}{This allows you to put in your own names in the nodes when generating the maze.}
}
\description{
This function generates an network Maze with 2 arrows.
}
\details{
This function creates a maze and is saved into your working directory. This is regardless of whether it is a trail or circuit type maze. 2 arrows per maze is generated.
}
\examples{
#create random names
countries <- c("Croatia","Cyprus","Denmark","Finland","France","Germany",
"Greece","Hungary","Iceland","UK","US")

#create node logic
logic <- nodeLogic(value = 8, type= "circuit", itemFamily= 1)

#Folder to save html/
#setwd("~/desktop")
#filePath<- getwd()

#Generate item
set.seed(1)
netHTML2arrows(logic, wd=NULL, names = countries)


}
\author{
Aiden Loe
}
