% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access.R, R/operators.R
\name{get.inducedSubgraph}
\alias{get.inducedSubgraph}
\alias{\%s\%}
\title{Retrieve Induced Subgraphs and Cuts}
\usage{
get.inducedSubgraph(x, v, alters = NULL, eid = NULL)

x \%s\% v
}
\arguments{
\item{x}{an object of class \code{network}.}

\item{v}{a vector of vertex IDs, or, for \code{\%s\%}, optionally a list containing two disjoint vectors of vertex IDs (see below).}

\item{alters}{optionally, a second vector of vertex IDs.  Must be disjoint
with \code{v}.}

\item{eid}{optionally, a numeric vector of valid edge ids in \code{x} that
should be retained (cannot be used with \code{v} or \code{alter})}
}
\value{
A \code{\link{network}} object containing the induced subgraph.
}
\description{
Given a set of vertex IDs, \code{get.inducedSubgraph} returns the subgraph
induced by the specified vertices (i.e., the vertices and all associated
edges).  Optionally, passing a second set of alters returns the cut from the
first to the second set (i.e., all edges passing between the sets), along
with the associated endpoints. Alternatively, passing in a vector of edge
ids will induce a subgraph containing the specified edges and their incident
vertices.  In all cases, the result is returned as a network object, with
all attributes of the selected edges and/or vertices (and any network
attributes) preserved.
}
\details{
For \code{get.inducedSubgraph}, \code{v} can be a vector of vertex IDs.  If
\code{alter=NULL}, the subgraph induced by these vertices is returned.
Calling \code{\%s\%} with a single vector of vertices has an identical effect.

Where \code{alters} is specified, it must be a vector of IDs disjoint with
\code{v}.  Where both are given, the edges spanning \code{v} and
\code{alters} are returned, along with the vertices in question.
(Technically, only the edges really constitute the \dQuote{cut,} but the
vertices are included as well.)  The same result can be obtained with the
\code{\%s\%} operator by passing a two-element list on the right hand side;
the first element is then interpreted as \code{v}, and the second as
\code{alters}.

When \code{eid} is specified, the \code{v} and \code{alters} argument will
be ignored and the subgraph induced by the specified edges and their
incident vertices will be returned.

Any network, vertex, or edge attributes for the selected network elements
are retained (although features such as vertex IDs and the network size will
typically change).  These are copies of the elements in the original
network, which is not altered by this function.
}
\examples{

#Load the Drabek et al. EMON data
data(emon)

#For the Mt. St. Helens, EMON, several types of organizations are present:
type<-emon$MtStHelens \%v\% "Sponsorship"

#Plot interactions among the state organizations
plot(emon$MtStHelens \%s\% which(type=="State"), displaylabels=TRUE)

#Plot state/federal interactions
plot(emon$MtStHelens \%s\% list(which(type=="State"), 
    which(type=="Federal")),  displaylabels=TRUE)

#Plot state interactions with everyone else
plot(emon$MtStHelens \%s\% list(which(type=="State"), 
    which(type!="State")), displaylabels=TRUE)
    
# plot only interactions with frequency of 2
subG2<-get.inducedSubgraph(emon$MtStHelens,
            eid=which(emon$MtStHelens\%e\%'Frequency'==2))
plot(subG2,edge.label='Frequency')


}
\seealso{
\code{\link{network}}, \code{\link{network.extraction}}
}
\author{
Carter T. Butts \email{buttsc@uci.edu}
}
\keyword{graphs}
\keyword{manip}
