% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossnma2netmeta.R
\name{crossnma2netmeta}
\alias{crossnma2netmeta}
\title{Create a netmeta object from a crossnma object}
\usage{
crossnma2netmeta(
  x,
  keep.samples = TRUE,
  level = gs("level"),
  level.ma = x$model$level.ma,
  reference.group = x$model$reference,
  baseline.reference = gs("baseline.reference"),
  small.values = x$model$small.values,
  all.treatments = gs("all.treatments"),
  seq = gs("seq"),
  backtransf = x$model$backtransf,
  nchar.trts = gs("nchar.trts"),
  nchar.studlab = gs("nchar.studlab")
)
}
\arguments{
\item{x}{A \code{crossnma} object created with R package \bold{crossnma}.}

\item{keep.samples}{A logical indicating whether to keep the generated
samples.}

\item{level}{The level used to calculate confidence intervals for
individual comparisons.}

\item{level.ma}{The level used to calculate confidence intervals
for network estimates.}

\item{reference.group}{Reference treatment (first treatment is used
if argument is missing).}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa. This argument is
only considered if \code{reference.group} has been specified.}

\item{small.values}{A character string specifying whether small
treatment effects indicate a beneficial (\code{"desirable"}) or
harmful (\code{"undesirable"}) effect (passed on to
\code{\link{netrank}}, can be abbreviated.}

\item{all.treatments}{A logical or \code{"NULL"}. If \code{TRUE},
matrices with all treatment effects, and confidence limits will
be printed.}

\item{seq}{A character or numerical vector specifying the sequence
of treatments in printouts.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and forest plots. If
\code{backtransf = TRUE}, results for \code{sm = "OR"} are
presented as odds ratios rather than log odds ratios, for
example.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names (see Details).}

\item{nchar.studlab}{A numeric defining the minimum number of
characters used to create unique study labels.}
}
\value{
A netmeta object with additional class "netmeta.crossnma".
}
\description{
Auxiliary function to create a netmeta object from a crossnma object
}
\examples{
\dontrun{
if (requireNamespace("crossnma", quietly = TRUE)) {
library("crossnma")
# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")
# Fit JAGS model
set.seed(1909)
fit <- crossnma(mod)

# Print results in netmeta layout
cro <- crossnma2netmeta(fit)
cro
# SUCRAs
netrank(cro)
# Rankogram
rankogram(cro)
}
}

}
\seealso{
\code{\link{netmeta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
