% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankogram.R
\name{rankogram}
\alias{rankogram}
\alias{print.rankogram}
\title{Calculate rankogram}
\usage{
rankogram(
  x,
  nsim = 1000,
  comb.fixed = x$comb.fixed,
  comb.random = x$comb.random,
  small.values = x$small.values
)

\method{print}{rankogram}(
  x,
  comb.fixed = x$comb.fixed,
  comb.random = x$comb.random,
  digits = max(3, .Options$digits - 4),
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{netmeta}}.}

\item{nsim}{Number of simulations.}

\item{comb.fixed}{A logical indicating to compute ranking
probabilities and SUCRAs for the fixed effects (common effects)
model.}

\item{comb.random}{A logical indicating to compute ranking
probabilities and SUCRAs for the random effects model.}

\item{small.values}{A character string specifying whether small
treatment effects indicate a beneficial (\code{"good"}) or
harmful (\code{"bad"}) effect, can be abbreviated.}

\item{digits}{Minimal number of significant digits, see
\code{\link{print.default}}.}

\item{\dots}{Additional arguments for printing.}
}
\value{
An object of class \code{rankogram} with corresponding \code{print}
and \code{plot} function. The object is a list containing the
following components:
\item{ranking.matrix.fixed}{Numeric matrix giving the probability
  of each treatment being at each possible rank for the fixed
  effects model.}
\item{ranking.fixed}{SUCRA values for the fixed effects model.}
\item{ranking.matrix.random}{Numeric matrix giving the probability
  of each treatment being at each possible rank for the random
  effects model.}
\item{ranking.random}{SUCRA values for the random effects model.}
\item{nsim, comb.fixed, comb.random}{As defined above},
\item{small.values, x}{As defined above},
}
\description{
This function calculates the probabilities of each treatment being
at each possible rank and the SUCRAs (Surface Under the Cumulative
RAnking curve) in frequentist network meta-analysis.
}
\details{
We derive a matrix showing the probability of each treatment being
at each possible rank. To this aim, we use resampling from a
multivariate normal distribution with estimated network effects as
means and corresponding estimated variance covariance matrix. We
then summarise them using the ranking metric SUCRAs (Surface Under
the Cumulative RAnking curve).
}
\examples{
data(Woods2010)
p1 <- pairwise(treatment, event = r, n = N, studlab = author,
               data = Woods2010, sm = "OR")
net1 <- netmeta(p1, small.values = "good")

ran1 <- rankogram(net1, nsim = 100)
ran1

plot(ran1)      

}
\references{
Salanti G, Ades AE, Ioannidis JP (2011):
Graphical methods and numerical summaries for presenting results
from multiple-treatment meta-analysis: an overview and tutorial.
\emph{Journal of Clinical Epidemiology},
\bold{64}, 163--71
}
\seealso{
\code{\link{netmeta}}, \code{\link{netrank}}
}
\author{
Thodoris Papakonstantinou \email{dev@tpapak.com}
}
