% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggnetmap.R
\name{ggnetmap}
\alias{ggnetmap}
\title{Fortify a network over a map}
\usage{
ggnetmap(
  n,
  m,
  lkp = NULL,
  m_name = NULL,
  n_name = "vertex.names",
  scale = FALSE,
  ...
)
}
\arguments{
\item{n}{A \code{network} or \code{igraph} object.}

\item{m}{A \code{sf} object.}

\item{lkp}{An optional lookup table.}

\item{m_name}{Optional \code{character}, name of field in \code{m} and of
column in \code{lkp}.}

\item{n_name}{Optional \code{character}, name of vertex attribute in \code{n}
and of column in \code{lkp}.}

\item{scale}{Whether coordinates should be scaled (defaults to FALSE since the
network should be overlayed with the non-scaled \code{sf} object).}

\item{...}{Additional parameters passed to \code{\link[ggnetwork]{fortify}}.}
}
\value{
A data frame, produced by \code{\link[ggnetwork]{fortify}}, which can be
used as data source in \code{ggplot2} graphs.
}
\description{
Link a \code{network} or \code{igraph} and a \code{sf} object in a
\code{data.frame} for subsequent representation on a plot using \code{ggplot2}.
}
\details{
Using a \code{network} or \code{igraph} and a \code{sf} object as inputs,
with an optional lookup table (a \code{data.frame}) in case the IDs don't
match, produces a \code{data.frame} that can be used with \code{ggnetwork}'s
\code{\link[ggnetwork]{geom_edges}} and \code{\link[ggnetwork]{geom_nodes}}
functions to represent the network as overlayed on a \code{sf} object in a
\code{ggplot2} graph. Only vertices with a corresponding feature in the
\code{sf} object are included.
}
\examples{
net=network::network(matrix(c(0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0), nrow=4, byrow=TRUE))
network::set.vertex.attribute(net, "name", value=c("a", "b", "c", "d"))
wkb = structure(list("01010000204071000000000000801A064100000000AC5C1641",
"01010000204071000000000000801A084100000000AC5C1441",
"01010000204071000000000000801A044100000000AC5C1241",
"01010000204071000000000000801A024100000000AC5C1841"), class = "WKB")
map=sf::st_sf(id=c("a1", "b2", "c3", "d4"), sf::st_as_sfc(wkb, EWKB=TRUE))
lkptbl=data.frame(id=c("a1", "b2", "c3", "d4"), name=c("a", "b", "c", "d"))
ggnetmap(net, map, lkptbl, "id", "name")
}
