% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeNetwork.R
\name{makeNetwork}
\alias{makeNetwork}
\title{Generate network based on coordinates.}
\usage{
makeNetwork(coordinates, distance.matrix = NULL, name = NULL,
  comment = NULL, membership = NULL, depot.coordinates = NULL,
  lower = NULL, upper = NULL)
}
\arguments{
\item{coordinates}{[\code{matrix}]\cr
Numeric matrix of 2D coordinates.}

\item{distance.matrix}{[\code{matrix}]\cr
Optional distance matrix.}

\item{name}{[\code{character(1)} | \code{NULL}]\cr
Optional name of the network.}

\item{comment}{[\code{character} | \code{NULL}]\cr
Optional additional comments on instance.}

\item{membership}{[\code{numeric} | \code{NULL}]\cr
Optional vector of memberships for clustered networks.}

\item{depot.coordinates}{[\code{matrix} | \code{NULL}]\cr
Numeric matrix of 2D coordinates of depots. Default is \code{NULL}, which
means no depots at all.}

\item{lower}{[\code{numeric(1)}]\cr
Lower box constraint of cube.}

\item{upper}{[\code{numeric(1)}]\cr
Upper box constraint of cube.}
}
\value{
[\code{Network}]
}
\description{
Generate network based on coordinates.
}

