% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_equiv.R
\name{transformGraphBy}
\alias{transformGraphBy}
\alias{transformGraphBy.diffnet}
\alias{transformGraphBy.dgCMatrix}
\title{Apply a function to a graph considering non-diagonal structural zeros}
\usage{
transformGraphBy(graph, INDICES, fun = function(g, ...) g, ...)

\method{transformGraphBy}{diffnet}(graph, INDICES, fun = function(g, ...)
  g, ...)

\method{transformGraphBy}{dgCMatrix}(graph, INDICES, fun = function(g,
  ...) g, ...)
}
\arguments{
\item{graph}{A graph}

\item{INDICES}{A vector of length \eqn{n}.}

\item{fun}{A function. This function must return a matrix of class
\code{\link[Matrix:dgCMatrix-class]{dgCMatrix}} with the same dimension as
\code{dim(g)}.}

\item{...}{Further arguments passed to \code{fun}}
}
\description{
When there are structural zeros given by groups, this function applies
a particular transformation function of a graph by groups returning a
square matrix of the same size of the original one with structural zeros
and the function applied by \code{INDICES}.
}
\details{
The transformation function \code{fun} must return a square matrix
of size \eqn{m\times m}{m*m}, where \eqn{m} is the size of the subgroup
given by \code{INDICES}. See examples below
}
\examples{
# Rewiring a graph by community --------------------------------------------

# Two Random graphs of different size
set.seed(123)
g0 <- rgraph_ba(m=2, self=FALSE)
g1 <- rgraph_ba(m=3, t=19, self=FALSE)

# Need a place to store both networks together!
G <- methods::new(
  Class = "dgCMatrix",
  Dim   = c(1L,1L)*(nnodes(g0) + nnodes(g1)),
  p     = rep(0L, (nnodes(g0) + nnodes(g1)) + 1L)
  )

# Filling the matrix
G[1:nnodes(g0),1:nnodes(g0)]                              <- g0
G[(nnodes(g0) + 1):nnodes(G), (nnodes(g0) + 1):nnodes(G)] <- g1

# Creating an index (community)
indx <- c(rep(1, nnodes(g0)), rep(2, nnodes(g1)))

# Apply the rewiring algorithm per group
ans <- transformGraphBy(G, indx, function(g, ...) {
  rewire_graph(g, 100, "swap")
  })

ans


}
