% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{threshold}
\alias{threshold}
\title{Retrive threshold levels from the exposure matrix}
\usage{
threshold(obj, toa, t0 = min(toa, na.rm = TRUE), include_censored = FALSE,
  lags = 0L, ...)
}
\arguments{
\item{obj}{Either a \eqn{n\times T}{n * T} matrix (eposure to the innovation obtained from
\code{\link{exposure}}) or a \code{diffnet} object.}

\item{toa}{Integer vector. Indicating the time of adoption of the innovation.}

\item{t0}{Integer scalar. See \code{\link{toa_mat}}.}

\item{include_censored}{Logical scalar. When \code{TRUE} (default), threshold}

\item{lags}{Integer scalar. Number of lags to consider when computing thresholds. \code{lags=1}
 defines threshold as exposure at \eqn{T-1}, where \code{T} is time of adoption.
levels are not reported for observations adopting in the first time period.}

\item{...}{Further arguments to be passed to \code{\link{exposure}}.}
}
\value{
A vector of size \eqn{n} indicating the threshold for each node.
}
\description{
Thresholds are each vertexes exposure at the time of adoption.
Substantively it is the proportion of adopters required for each ego to adopt. (see \code{\link{exposure}}).
}
\details{
By default exposure is not computed for vertices adopting at the
first time period, \code{include_censored=FALSE}, as estimating threshold for
left censored data may yield biased outcomes.
}
\examples{
# Generating a random graph with random Times of Adoption
set.seed(783)
toa <- sample.int(4, 5, TRUE)
graph <- rgraph_er(n=5, t=max(toa) - min(toa) + 1)

# Computing exposure using Structural Equivalnece
adopt <- toa_mat(toa)
se <- struct_equiv(graph)
se <- lapply(se, function(x) methods::as((x$SE)^(-1), "dgCMatrix"))
expo <- exposure(graph, adopt$cumadopt, alt.graph=se)

# Retrieving threshold
threshold(expo, toa)

# We can do the same by creating a diffnet object
diffnet <- as_diffnet(graph, toa)
threshold(diffnet, alt.graph=se)
}
\seealso{
Threshold can be visualized using \code{\link{plot_threshold}}

Other statistics: \code{\link{bass}},
  \code{\link{classify_adopters}},
  \code{\link{cumulative_adopt_count}}, \code{\link{dgr}},
  \code{\link{ego_variance}}, \code{\link{exposure}},
  \code{\link{hazard_rate}}, \code{\link{infection}},
  \code{\link{moran}}, \code{\link{struct_equiv}},
  \code{\link{vertex_covariate_dist}}
}
\author{
George G. Vega Yon, Stephanie R. Dyal, Timothy B. Hayes & Thomas W. Valente
}
\keyword{univar}
