% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{pretty_within}
\alias{pretty_within}
\title{Pretty numbers within a range.}
\usage{
pretty_within(x, min.n = 5, xrange = range(x, na.rm = TRUE), ...)
}
\arguments{
\item{x}{Numeric vector passed to \code{\link[base:pretty]{pretty}}.}

\item{min.n}{Integer scalar passed to \code{\link[base:pretty]{pretty}}.}

\item{xrange}{Numeric vector of length 2. Indicates the range in which the
output vector should lie on.}

\item{...}{Further arguments passed to the method.

The only difference with \code{pretty} is that this function subsets the
resulting vector as

\code{tick[(tick >= xrange[1]) & (tick <= xrange[2])]}}
}
\description{
A wrapper for \code{\link[base:pretty]{pretty}}.
}
\examples{
# Simple example ------------------------------------------------------------
set.seed(3331)
x <- runif(10)
pretty(x)
pretty_within(x)
range(x)

}
\keyword{misc}

