% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.R
\name{plot_threshold}
\alias{plot_threshold}
\title{Threshold levels through time}
\usage{
plot_threshold(graph, expo, toa, include_censored = FALSE, t0 = min(toa,
  na.rm = TRUE), attrs = NULL, undirected = getOption("diffnet.undirected"),
  no.contemporary = TRUE, main = "Time of Adoption by Network Threshold",
  xlab = "Time", ylab = "Threshold", vertex.cex = "degree",
  vertex.col = rgb(0.3, 0.3, 0.8, 0.5), vertex.label = "",
  vertex.lab.pos = NULL, vertex.lab.cex = 1, vertex.lab.adj = c(0.5, 0.5),
  vertex.lab.col = rgb(0.3, 0.3, 0.8, 0.9), vertex.sides = 40,
  vertex.rot = 0, edge.width = 2, edge.col = rgb(0.6, 0.6, 0.6, 0.1),
  arrow.length = 0.2, include.grid = TRUE, bty = "n",
  vertex.bcol = vertex.col, jitter.factor = c(1, 0),
  jitter.amount = c(0.25, 0), xlim = NULL, ylim = NULL, ...)
}
\arguments{
\item{graph}{A dynamic graph (see \code{\link{netdiffuseR-graphs}}).}

\item{expo}{\eqn{n\times T}{n * T} matrix. Esposure to the innovation obtained from \code{\link{exposure}}}

\item{toa}{Integer vector of size \eqn{n}. Times of Adoption}

\item{include_censored}{Logical scalar. Passed to \code{\link{threshold}}.}

\item{t0}{Integer scalar. Passed to \code{\link{threshold}}.}

\item{attrs}{Passed to \code{\link{exposure}} (via threshold).}

\item{undirected}{Logical scalar.}

\item{no.contemporary}{Logical scalar. When TRUE, edges for vertices with the same
\code{toa} won't be plotted.}

\item{main}{Character scalar. Title of the plot.}

\item{xlab}{Character scalar. x-axis label.}

\item{ylab}{Character scalar. y-axis label.}

\item{vertex.cex}{Numeric vector of size \eqn{n}. Relative size of the vertices.}

\item{vertex.col}{Either a vector of size \eqn{n} or a scalar indicating colors of the vertices.}

\item{vertex.label}{Character vector of size \eqn{n}. Labels of the vertices.}

\item{vertex.lab.pos}{Integer value to be passed to \code{\link{text}} via \code{pos}.}

\item{vertex.lab.cex}{Either a numeric scalar or vector of size \eqn{n}. Passed to \code{text}.}

\item{vertex.lab.adj}{Passed to \code{\link{text}}.}

\item{vertex.lab.col}{Passed to \code{\link{text}}.}

\item{vertex.sides}{Either a vector of size \eqn{n} or a scalar indicating the
number of sides of each vertex (see details).}

\item{vertex.rot}{Either a vector of size \eqn{n} or a scalar indicating the
rotation in radians of each vertex (see details).}

\item{edge.width}{Numeric. Width of the edges.}

\item{edge.col}{Character. Color of the edges.}

\item{arrow.length}{Numeric value to be passed to \code{\link{arrows}}.}

\item{include.grid}{Logical. When TRUE, the grid of the graph is drawn.}

\item{bty}{See \code{\link{par}}.}

\item{vertex.bcol}{Either a vector of size \eqn{n} or a scalar indicating colors of vertices' borders.}

\item{jitter.factor}{Numeric vector of size 2 (for x and y) passed to \code{\link{jitter}}.}

\item{jitter.amount}{Numeric vector of size 2 (for x and y) passed to \code{\link{jitter}}.}

\item{xlim}{Passed to \code{\link{plot}}.}

\item{ylim}{Passed to \code{\link{plot}}.}

\item{...}{Additional arguments passed to \code{\link{plot}}.}
}
\description{
Draws a graph where the coordinates are given by time of adoption, x-axis,
and threshold level, y-axis.
}
\details{
When \code{vertex.label=NULL} the function uses vertices ids as labels.
By default \code{vertex.label=""} plots no labels.

Vertices are drawn using an internal function for generating polygons.
Polygons are inscribed in a circle of radius \code{vertex.cex}, and can be
rotated using \code{vertex.rot}. The number of sides of each polygon
is set via \code{vertex.sides}.
}
\examples{

# Generating a random graph
set.seed(1234)
n <- 6
nper <- 5
graph <- rgraph_er(n,nper, p=.3, undirected = FALSE)
toa <- sample(2000:(2000+nper-1), n, TRUE)
adopt <- toa_mat(toa)

# Computing exposure
expos <- exposure(graph, adopt$cumadopt)

plot_threshold(graph, expos, toa)

# Calculating degree (for sizing the vertices)
plot_threshold(graph, expos, toa, vertex.cex = "indegree")

}
\author{
George G. Vega Yon
}
\seealso{
Use \code{\link{threshold}} to retrieve the corresponding threshold
obtained returned by \code{\link{exposure}}.

Other visualizations: \code{\link{hazard_rate}},
  \code{\link{plot_adopters}}, \code{\link{plot_diffnet}},
  \code{\link{plot_infectsuscep}}
}
\keyword{hplot}

