% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{multiloglikechain}
\alias{multiloglikechain}
\title{Derive log-likelihood of conditional log-linear model given parameters.}
\usage{
multiloglikechain(pars, listobservations, permutetab, edgeY, edgeAY,
  edgeExtra)
}
\arguments{
\item{pars}{a set of parameters}

\item{listobservations}{a collection of \code{[(2+nc) x m ]} matrices comprised of outcomes (first row), treatments (second row), and confounders (from the third row), where \code{nc} is the number of confounders.}

\item{permutetab}{a matrix comprised of every possible values for outcome in each row.}

\item{edgeY}{a matrix of which each row indicates a pair of index for adjacent outcomes.}

\item{edgeAY}{a matrix of which each row indicates a index for treatment (first column) and for outcome (second column) on which the treatment has a direct effect.}

\item{edgeExtra}{a list of edges of which a list of matrix specifying additional directed edges (from confounders or treatment to the outcomes) information.}
}
\value{
log-likelihood of conditional log-linear model given parameters, observations, and edge information.
}
\description{
Derive log-likelihood of conditional log-linear model given parameters.
}
