% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{collinear}
\alias{collinear}
\title{Filter to reduce collinearity in predictors}
\usage{
collinear(x, rsq_cutoff = 0.9, rsq_method = "pearson", verbose = FALSE)
}
\arguments{
\item{x}{A matrix or data.frame of values. The order of columns is used to
determine which columns to retain, so the columns in \code{x} should be sorted
with the most important columns first.}

\item{rsq_cutoff}{Value of cut-off for r-squared}

\item{rsq_method}{character string indicating which correlation coefficient
is to be computed. One of "pearson" (default), "kendall", or "spearman".
See \code{\link[=cor]{cor()}}.}

\item{verbose}{Boolean whether to print details}
}
\value{
Integer vector of the indices of columns in \code{x} to remove due to
collinearity
}
\description{
This function identifies predictors with r^2 above a given cut-off and
produces an index of predictors to be removed. The function takes a matrix or
data.frame of predictors, and the columns need to be ordered in terms of
importance - first column of any pair that are correlated is retained and
subsequent columns which correlate above the cut-off are flagged for removal.
}
