% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_neat.R
\name{corr_neat}
\alias{corr_neat}
\title{Correlation Statistics}
\usage{
corr_neat(
  var1,
  var2,
  nonparametric = FALSE,
  ci = 0.95,
  bf_added = TRUE,
  direction = NULL,
  round_r = 3,
  for_table = FALSE,
  sb_correction = FALSE,
  hush = FALSE
)
}
\arguments{
\item{var1}{Numeric vector; numbers of the first variable.}

\item{var2}{Numeric vector; numbers of the second variable.}

\item{nonparametric}{Logical (\code{FALSE} by default). If \code{TRUE}, uses
nonparametric tests (Spearman's rank correlation, including BFs; see
Details).}

\item{ci}{Numeric; confidence level for the returned CI, as implemented in
\code{\link[stats]{cor.test}}.}

\item{bf_added}{Logical. If \code{TRUE} (default), Bayes factor is calculated
and displayed.}

\item{direction}{\code{NULL} or string; optionally specifies one-sided test:
either "negative" (negative correlation expected) or "positive" (positive
correlation expected). (Short forms also work, e.g. "p", "pos", "neg", etc.)
If \code{NULL} (default), the test is two-sided.}

\item{round_r}{Number \code{\link[=ro]{to round}} to the correlation and its
CI.}

\item{for_table}{Logical. If \code{TRUE}, omits the confidence level display
from the printed text.}

\item{sb_correction}{Logical. If \code{TRUE}, applies Spearman-Brown
correction (\code{2 * r / (1+r)}) to the correlation (including CI).}

\item{hush}{Logical. If \code{TRUE}, prevents printing any details to console.}
}
\value{
Prints correlation statistics (including CI and BF) in APA style.
 Furthermore, when assigned, returns a named vector with the following
 elements: \code{r} (Pearson correlation), \code{p} (p value), \code{bf}
 (Bayes factor).
}
\description{
\code{\link[stats:cor.test]{Pearson correlation}} results
 including confidence interval (CI) and correlation
 \code{\link[BayesFactor:correlationBF]{Bayes factor}} (BF). For
 non-parametric version, Spearman's \code{\link[stats:cor.test]{rank
 correlation}} results along with corresponding rank-based BFs (as per van
 Doorn et al., 2020).
}
\details{
The Bayes factor (BF) is calculated with the default r-scale of
 \code{1/3} for parametric test, and with the default r-scale of \code{1} for
 nonparametric test. BF supporting null hypothesis is denoted as BF01, while
 that supporting alternative hypothesis is denoted as BF10. When the BF is
 smaller than 1 (i.e., supports null hypothesis), the reciprocal is
 calculated (hence, BF10 = BF, but BF01 = 1/BF). When the BF is greater than
 or equal to 10000, scientific (exponential) form is reported for
 readability. (The original full BF number is available in the returned named
 vector as \code{bf}.)#'
}
\note{
The correlation and CI is calculated via
\code{\link[stats:cor.test]{stats::cor.test}}.

The Bayes factor is calculated via
\code{\link[BayesFactor:correlationBF]{BayesFactor::correlationBF}}.
}
\examples{
# assign two variables
v1 = c(11, 15, 19, 43, 53, -4, 34, 8, 33, -1, 54 )
v2 = c(4, -2, 23, 13, 32, 16, 3, 29, 37, -4, 65 )

corr_neat(v1, v2) # prints statistics

# one-sided, and omitting the "95\% CI" part
corr_neat(v1, v2, direction = 'pos', for_table = TRUE)

# print statistics and assign main results
results = corr_neat(v1, v2, direction = 'pos')

results['p'] # get precise p value
}
\references{
Brown, W. (1910). Some experimental results in the correlation of mental
abilities. British Journal of Psychology, 1904-1920, 3(3), 296-322.
\doi{https://doi.org/10.1111/j.2044-8295.1910.tb00207.x}

Eisinga, R., Grotenhuis, M. te, & Pelzer, B. (2013). The reliability of a
two-item scale: Pearson, Cronbach, or Spearman-Brown? International Journal of
Public Health, 58(4), 637-642. \doi{https://doi.org/10.1007/s00038-012-0416-3}

Spearman, C. (1910). Correlation calculated from faulty data. British Journal
of Psychology, 1904-1920, 3(3), 271-295.
\doi{https://doi.org/10.1111/j.2044-8295.1910.tb00206.x}

van Doorn, J., Ly, A., Marsman, M., & Wagenmakers, E.-J. (2020). Bayesian
rank-based hypothesis testing for the rank sum test, the signed rank test, and
Spearman’s rho. Journal of Applied Statistics, 1–23.
\doi{https://doi.org/10.1080/02664763.2019.1709053}
}
\seealso{
\code{\link{t_neat}}
}
