% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{predict.ncpen}
\alias{predict.ncpen}
\title{Make predictions from an \code{ncpen} object.}
\usage{
\method{predict}{ncpen}(object, new.x.mat = NULL, type = c("regression",
  "probability", "response"), cut = 0.5, ...)
}
\arguments{
\item{object}{fitted \code{ncpen} object.}

\item{new.x.mat}{(numeric \code{\link{matrix}}). A matrix of new observations at which predictions are to be made.}

\item{type}{(character) type of prediction.
\code{"regression"} returns the linear predictors;
\code{"probability"} returns the fitted probabilities which is only available for \code{family="binomial"};
\code{"response"} returns followings depending on the models: the fitted values for \code{"gaussian"},
fitted class using \code{cut} value for \code{"binomial"}, and fitted means for \code{"poisson"}.}

\item{cut}{(numeric) threshold value of probability for logistic regression model. Default value is 0.5.
This argument is only required for logistic regression (binomial).}

\item{...}{Other parameters to prediction. Not supported.}
}
\value{
the \code{\link{matrix}} of the fitted values depending on \code{type} for all lambda values.
}
\description{
This function provides predictions from a fitted \code{ncpen} object.
}
\examples{

### Linear regression
s0 = sam.gen.fun(n=100,p=20,q=10,bmin=0.5,bmax=1,corr=0.5,family="gaussian")
x.mat = s0$x.mat
y.vec = s0$y.vec

fit = ncpen(y.vec=y.vec, x.mat=x.mat, family="gaussian")
predict(fit, new.x.mat=x.mat[1:20,], type="regression")

### Logistic regression
s0 = sam.gen.fun(n=100,p=20,q=10,bmin=0.5,bmax=1,corr=0.5,family="binomial")
x.mat = s0$x.mat
y.vec = s0$y.vec

fit = ncpen(y.vec=y.vec, x.mat=x.mat, family="binomial")
predict(fit, new.x.mat=x.mat[1:20,], type="probability")
predict(fit, new.x.mat=x.mat[1:20,], type="response")

### Poisson regression
s0 = sam.gen.fun(n=100,p=20,q=10,bmin=0.5,bmax=1,corr=0.5,family="poisson")
x.mat = s0$x.mat
y.vec = s0$y.vec

fit = ncpen(y.vec=y.vec, x.mat=x.mat, family="poisson")
predict(fit, new.x.mat=x.mat[1:20,], type="regression")
predict(fit, new.x.mat=x.mat[1:20,], type="response")

}
\references{
Kwon, S., Lee, S. and Kim, Y. (2016). Moderately clipped LASSO. \emph{Computational Statistics and Data Analysis}, \bold{92C}, 53-67.
}
\seealso{
\code{\link{ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee

Maintainer: Dongshin Kim<dongshin.kim@outlook.com>, Sunghoon Kwon<shkwon0522@gmail.com>
}
