% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFResource.R
\docType{class}
\name{CFResource}
\alias{CFResource}
\title{NetCDF resource object}
\description{
This class contains the connection details to a netCDF resource.

There is a single instance of this class for every netCDF resource, owned
by the \link{CFDataset} instance. The instance is shared by other objects,
specifically \link{NCGroup} and \link{CFVariable} instances, for access to the
underlying resource for reading of data.

This class should never have to be accessed directly. All access is handled
by higher-level methods.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{error}}{Error message, or empty string.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}

\item{\code{handle}}{(read-only) The handle to the netCDF resource.}

\item{\code{uri}}{(read-only) The URI of the netCDF resource, either a local
filename or the location of an online resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFResource-new}{\code{CFResource$new()}}
\item \href{#method-CFResource-close}{\code{CFResource$close()}}
\item \href{#method-CFResource-group_handle}{\code{CFResource$group_handle()}}
\item \href{#method-CFResource-clone}{\code{CFResource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFResource-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFResource-new}{}}}
\subsection{Method \code{new()}}{
Create a connection to a netCDF resource. This is called by
\code{\link[=open_ncdf]{open_ncdf()}} when opening a netCDF resource; you should never have to
call this directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFResource$new(uri)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uri}}{The URI to the netCDF resource.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFResource-close"></a>}}
\if{latex}{\out{\hypertarget{method-CFResource-close}{}}}
\subsection{Method \code{close()}}{
Closing an open netCDF resource. It should rarely be
necessary to call this method directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFResource$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFResource-group_handle"></a>}}
\if{latex}{\out{\hypertarget{method-CFResource-group_handle}{}}}
\subsection{Method \code{group_handle()}}{
Every group in a netCDF file has its own handle, with the
"root" group having the handle for the entire netCDF resource. The
handle returned by this method is valid only for the named group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFResource$group_handle(group_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group_name}}{The absolute path to the group.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The handle to the group.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFResource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFResource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFResource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
