% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xformimage.R
\name{xformimage}
\alias{xformimage}
\alias{xformimage.character}
\alias{xformimage.cmtkreg}
\alias{xformimage.default}
\title{Transform image files using a registration or affine matrix}
\usage{
xformimage(reg, image, ...)

\method{xformimage}{character}(reg, image, ...)

\method{xformimage}{cmtkreg}(reg, image, transformtype = c("warp", "affine"),
  direction = NULL, ...)

\method{xformimage}{default}(reg, image, ...)
}
\arguments{
\item{reg}{A registration defined by a matrix or a \code{cmtkreg} object, or
a character vector specifying a path to a CMTK registration on disk (see
details). If \code{reg} is a character vector of length >1 defining a
sequence of registration files on disk they should proceed from sample to
reference.}

\item{image}{Nx3 matrix of image}

\item{...}{Additional arguments passed to methods (and then eventually to
\code{\link{cmtk.reformatx}})}

\item{transformtype}{Which transformation to use when the CMTK file contains
both warp (default) and affine (TODO)}

\item{direction}{Whether to transform image from sample space to reference
space (called \strong{forward} by CMTK) or from reference to sample space
(called \strong{inverse} by CMTK). Default (when \code{NULL} is forward).}
}
\value{
Character vector with path to xformed image.
}
\description{
You should almost always call \code{\link{xform}} rather
  calling than\code{xformimage} directly.
}
\details{
When passed a character vector, xformimage will check to see if it
  defines a path containing CMTK registration erroring out if this is not the
  case. If the path does indeed point to a CMTK registration, this method
  will hand off to xformimage.cmtkreg. A future TODO would be to provide a
  mechanism for extending this behaviour for other registration formats.
  If a list of transformations is passed in, these transformations are passed
  to the cmtk reformatx tool in the order received. Note that there is
  presently no support for \itemize{

  \item using the inverse of a registration

  \item specifying a mask

  \item passing additional arguments to reformatx

  }

Note that the direction of CMTK registrations can be the source of
  much confusion. This is because CMTK defines the \emph{forward} direction
  as the transform required to reformat an image in \emph{sample} (floating)
  space to an image in \emph{template} space. Since this operation involves
  filling a regular grid in template space by looking up the corresponding
  positions in sample space, the transformation that is required is (somewhat
  counterintuitively) the one that maps template to sample. However in
  neuroanatomical work, one often has points in sample space that one would
  like to transform into template space. Here one needs CMTK's \emph{inverse}
  transformation.

  A second source of confusion is that when there are multiple
  transformations, CMTK's reformatx tool (wrapped by
  \code{\link{cmtk.reformatx}}) expects them to be listed:

  \code{ref_intermediate.list intermediate_sample.list}

  where \code{ref_intermediate.list} is the CMTK registration obtained with
  ref as target/reference and intermediate as sample/floating image.

  For consistency, all \code{xform.*} methods expect multiple registrations
  to be listed from sample to reference and this order is then swapped when
  they are passed on to \code{cmtk.reformatx}.

  whereas CMTK's streamxform tool (wrapped by \code{\link{xformpoints}})
  expects them in the opposite order.
}
\seealso{
\code{\link{cmtk.reformatx}}, \code{\link{xformpoints}},
  \code{\link{xform}}
}

