% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{mirror_brain}
\alias{mirror_brain}
\title{Mirror 3D object around a given axis, optionally using a warping registration}
\usage{
mirror_brain(
  x,
  brain = regtemplate(x),
  mirrorAxis = c("X", "Y", "Z"),
  transform = c("warp", "affine", "flip"),
  ...
)
}
\arguments{
\item{x}{the 3D object to be mirrored.}

\item{brain}{source template brain (e.g. IS2) that data is in.}

\item{mirrorAxis}{the axis to mirror (default \code{"X"}).}

\item{transform}{whether to use warp (default) or affine component of
registration, or simply flip about midplane of axis.}

\item{...}{extra arguments to pass to \code{\link[nat]{mirror}}.}
}
\value{
A transformed version of \code{x}
}
\description{
Mirror 3D object around a given axis, optionally using a warping registration
}
\examples{
data(FCWB.demo)
# Simple mirror along the x i.e. medio-lateral axis
kcs20.flip=mirror_brain(kcs20, FCWB.demo, transform='flip')

## Full non-rigid mirroring to account for differences in shape/centering of
## template brain.
## Depends on nat.flybrains package and system CMTK installation
\dontrun{
library(nat.flybrains)
kcs20.right=mirror_brain(kcs20, FCWB, .progress='text')
plot3d(kcs20, col='red')
plot3d(kcs20.right, col='green')
# include surface plot of brain
plot3d(FCWB)

# Compare simple flip with full mirror
# This template brain is highly symmetric so these are almost identical
clear3d()
plot3d(kcs20.flip, col='blue')
plot3d(kcs20.right, col='green')

# Convert to JFRC2 and do the same
kcs20.jfrc2=xform_brain(kcs20, sample = FCWB, reference=JFRC2, .progress='text')
kcs20.jfrc2.right=mirror_brain(kcs20.jfrc2, JFRC2, .progress='text')
kcs20.jfrc2.flip=mirror_brain(kcs20.jfrc2, JFRC2, transform='flip')
clear3d()
# This time there is a bigger difference between the two transformations
plot3d(kcs20.jfrc2.flip, col='blue')
plot3d(kcs20.jfrc2.right, col='green')
# plot mushroom body neuropils as well
plot3d(JFRC2NP.surf, "MB.*_R", alpha=0.3, col='grey')

# Compare Euclidean distance between corresponding points in all neurons
diffs=xyzmatrix(kcs20.jfrc2.flip)-xyzmatrix(kcs20.jfrc2.right)
hist(sqrt(rowSums(diffs^2)), xlab='Distance /microns')
}
}
\seealso{
\code{\link{xform_brain}}, \code{\link{regtemplate}}
}
