% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanoparquet-package.R
\docType{package}
\name{nanoparquet-package}
\alias{nanoparquet}
\alias{nanoparquet-package}
\title{nanoparquet: Read Parquet Files}
\description{
Self-sufficient reader and writer for flat Parquet files. Can read most Parquet data types. Can write many R data types, including factors and temporal types. Supports Snappy compression.
}
\details{
\code{nanoparquet} is a reader and writer for a common subset of Parquet files.
\subsection{Features:}{
\itemize{
\item Read and write flat (i.e. non-nested) Parquet files.
\item Can read most \href{https://r-lib.github.io/nanoparquet/reference/nanoparquet-types.html}{Parquet data types}.
\item Can write many R data types, including factors and temporal types
to Parquet.
\item Completely dependency free.
\item Supports Snappy compression.
}
}

\subsection{Limitations:}{
\itemize{
\item Nested Parquet types are not supported.
\item Some Parquet logical types are not supported: \code{FLOAT16}, \code{INTERVAL},
\code{UNKNOWN}.
\item The \code{FIXED_LEN_BYTE_ARRAY} Parquet type is not supported, unless it
represents a supported logical type.
\item Only Snappy compression is supported.
\item Encryption is not supported.
\item Being single-threaded and not fully optimized, nanoparquet is probably
not suited well for large data sets. It should be fine for a couple of
gigabytes. Reading or writing a ~250MB file that has 32 million rows and 14 columns takes about 10-15 seconds on an M2 MacBook Pro.
For larger files, use Apache Arrow or DuckDB.
}
}

\subsection{Installation}{

Install the R package from CRAN:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("nanoparquet")
}\if{html}{\out{</div>}}
}

\subsection{Usage}{
\subsection{Read}{

Call \code{read_parquet()} to read a Parquet file:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{df <- nanoparquet::read_parquet("example.parquet")
}\if{html}{\out{</div>}}

Folders of similar-structured Parquet files (e.g. produced by Spark)
can be read like this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{df <- data.table::rbindlist(lapply(
  Sys.glob("some-folder/part-*.parquet"),
  nanoparquet::read_parquet
))
}\if{html}{\out{</div>}}
}

\subsection{Write}{

Call \code{write_parquet()} to write a data frame to a Parquet file:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{nanoparquet::write_parquet(mtcars, "mtcars.parquet")
}\if{html}{\out{</div>}}
}

\subsection{Inspect}{

Call \code{parquet_info()}, \code{parquet_columns()}, \code{parquet_schema()} or
\code{parquet_metadata()} to see various kinds of metadata from a Parquet
file:
\itemize{
\item \code{parquet_info()} shows a basic summary of the file.
\item \code{parquet_columns()} shows the leaf columns, these are are the ones
that \code{read_parquet()} reads into R.
\item \code{parquet_schema()} shows all columns, including non-leaf columns.
\item \code{parquet_metadata()} shows the most complete metadata information:
file meta data, the schema, the row groups and column chunks of the
file.
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{nanoparquet::parquet_info("mtcars.parquet")
nanoparquet::parquet_columns("mtcars.parquet")
nanoparquet::parquet_schema("mtcars.parquet")
nanoparquet::parquet_metadata("mtcars.parquet")
}\if{html}{\out{</div>}}

If you find a file that should be supported but isn't, please open an
issue here with a link to the file.
}

}

\subsection{Options}{
\itemize{
\item \code{nanoparquet.class}: extra class to add to data frames returned by
\code{read_parquet()}. If it is not defined, the default is \code{"tbl"},
which changes how the data frame is printed if the pillar package is
loaded.
\item \code{nanoparquet.use_arrow_metadata}: unless this is set to \code{FALSE},
\code{read_parquet()} will make use of Arrow metadata in the Parquet file.
Currently this is used to detect factor columns.
\item \code{nanoparquet.write_arrow_metadata}: unless this is set to \code{FALSE},
\code{write_parquet()} will add Arrow metadata to the Parquet file.
This helps preserving classes of columns, e.g. factors will be read
back as factors, both by nanoparquet and Arrow.
}
}

\subsection{License}{

MIT
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-lib/nanoparquet}
  \item \url{https://r-lib.github.io/nanoparquet/}
  \item Report bugs at \url{https://github.com/r-lib/nanoparquet/issues}
}

}
\author{
\strong{Maintainer}: Gábor Csárdi \email{csardi.gabor@gmail.com}

Authors:
\itemize{
  \item Hannes Mühleisen (\href{https://orcid.org/0000-0001-8552-0029}{ORCID}) [copyright holder]
}

Other contributors:
\itemize{
  \item Google Inc. [copyright holder]
  \item Apache Software Foundation [copyright holder]
  \item Posit Software, PBC [copyright holder]
}

}
