% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{reply}
\alias{reply}
\title{Reply over Context (RPC Server for Req/Rep Protocol)}
\usage{
reply(
  context,
  execute,
  recv_mode = c("serial", "character", "complex", "double", "integer", "logical",
    "numeric", "raw"),
  send_mode = c("serial", "raw", "next"),
  timeout = NULL,
  ...
)
}
\arguments{
\item{context}{a Context.}

\item{execute}{a function which takes the received (converted) data as its
first argument. Can be an anonymous function of the form \code{function(x) do(x)}.
Additional arguments can also be passed in through '...'.}

\item{recv_mode}{[default 'serial'] mode of vector to be received - one of
'serial', 'character', 'complex', 'double', 'integer', 'logical',
'numeric', 'raw', or 'string'. The default 'serial' means a serialised R
object, for the other modes, the raw vector received will be converted
into the respective mode. Note that 'string' is defined here as a character
scalar and is a faster alternative to 'character' for receiving a single
string. Alternatively, for performance, specify an integer position in
the vector of choices e.g. 1L for 'serial', 2L for 'character' etc.}

\item{send_mode}{[default 'serial'] one of 'serial' to send serialised R objects,
'raw' to send atomic vectors of any type as a raw byte vector, or 'next'
to send in a new R-compatible serialisation format. Use 'serial' to ensure
perfect reproducibility within R, although 'raw' must be used when
interfacing with external applications which do not understand R
serialisation. Alternatively, for performance, specify an integer position
in the vector of choices e.g. 1L for 'serial' or 2L for 'raw' etc.}

\item{timeout}{[default NULL] integer value in milliseconds or NULL, which
applies a socket-specific default, usually the same as no timeout. Note
that this applies to receiving the request. The total elapsed time would
also include performing 'execute' on the received data. The timeout then
also applies to sending the result (in the event that the requestor has
become unavailable since sending the request).}

\item{...}{additional arguments passed to the function specified by 'execute'.}
}
\value{
Integer exit code (zero on success).
}
\description{
Implements an executor/server for the rep node of the req/rep protocol. Awaits
    data, applies an arbitrary specified function, and returns the result
    to the caller/client.
}
\details{
Receive will block while awaiting a message to arrive and is usually
    the desired behaviour. Set a timeout to allow the function to return
    if no data is forthcoming.

    In the event of an error in either processing the messages or in evaluation
    of the function with respect to the data, a nul byte \code{00} (or serialized
    nul byte) will be sent in reply to the client to signal an error. This is
    to be distinguishable from a possible return value. \code{\link{is_nul_byte}}
    can be used to test for a nul byte.
}
\examples{
req <- socket("req", listen = "tcp://127.0.0.1:6546")
rep <- socket("rep", dial = "tcp://127.0.0.1:6546")

ctxq <- context(req)
ctxp <- context(rep)

send(ctxq, 2022, block = 100)
reply(ctxp, execute = function(x) x + 1, send_mode = "raw", timeout = 100)
recv(ctxq, mode = "double", block = 100)

send(ctxq, 100, mode = "raw", block = 100)
reply(ctxp, recv_mode = "double", execute = log, base = 10, timeout = 100)
recv(ctxq, block = 100)

close(req)
close(rep)

}
