% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/socket.R
\name{unsubscribe}
\alias{unsubscribe}
\title{Unsubscribe Topic}
\usage{
unsubscribe(socket, topic = NULL)
}
\arguments{
\item{socket}{a Socket.}

\item{topic}{[default NULL] a topic (given as a character string). The default
NULL unsubscribes from all topics (if all topics were previously subscribed).}
}
\value{
Zero (invisibly) on success.
}
\description{
For a socket using the sub protocol in a publisher/subscriber pattern. Remove
    a topic from the subscription list.
}
\details{
Note that if the topic was not previously subscribed to then an
    'entry not found' error will result.

    To use pub/sub you must use \code{\link{send_vec}} and \code{\link{recv_vec}}
    so that the messages are not serialised otherwise the topics will not be
    recognised.

    Note: the publisher needs to send a vector that separates the topic from
    the rest of the message such as \code{send_vec(socket, c("topic", "message"))}
    (this ensures that topic ends with the required null byte for it to be
    recognised).
}
\examples{
pub <- socket("pub", listen = "inproc://nanonext")
sub <- socket("sub", dial = "inproc://nanonext")

subscribe(sub, NULL)
send_vec(pub, c("examples", "this is an example"))
recv_vec(sub, "character")
unsubscribe(sub, NULL)
send_vec(pub, c("examples", "this example will not be received"))
recv_vec(sub, "character")

close(pub)
close(sub)

}
