% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{recv}
\alias{recv}
\title{Receive}
\usage{
recv(socket, block = FALSE, keep.raw = TRUE)
}
\arguments{
\item{socket}{a Socket.}

\item{block}{[default FALSE] logical flag whether to block until successful
or return immediately even if unsuccessful (e.g. nothing to receive).}

\item{keep.raw}{[default TRUE] TRUE to keep the received raw vector (useful
for verification e.g. via hashing). If FALSE, will return the
unserialised object only.}
}
\value{
Named list of 2 elements: 'raw' containing the received raw vector
    and 'data' containing the unserialised R object, or else the unserialised
    R object if 'keep.raw' is set to FALSE.
}
\description{
Receive serialised data over a Socket. For sending and receiving within R.
}
\details{
In case of an error in unserialisation (e.g. the data was not sent
    serialised), the function will still return the received raw vector to
    allow the data to be recovered.
}
\examples{
s1 <- socket("bus", listen = "inproc://nanonext")
s2 <- socket("bus", dial = "inproc://nanonext")

send(s1, data.frame(a = 1, b = 2))
res <- recv(s2)
res

send(s1, data.frame(a = 1, b = 2), echo = FALSE)
recv(s2, keep.raw = FALSE)

close(s1)
close(s2)

}
