% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_mean.R
\name{scoped-impute_mean}
\alias{scoped-impute_mean}
\alias{impute_mean_all}
\alias{impute_mean_at}
\alias{impute_mean_if}
\title{Scoped variants of \code{impute_mean}}
\usage{
impute_mean_all(.tbl)

impute_mean_at(.tbl, .vars)

impute_mean_if(.tbl, .predicate)
}
\arguments{
\item{.tbl}{a data.frame}

\item{.vars}{variables to impute}

\item{.predicate}{variables to impute}
}
\value{
an dataset with values imputed
}
\description{
\code{impute_mean} imputes the mean for a vector. To get it to work on all
variables, use \code{impute_mean_all}. To only impute variables
that satisfy a specific condition, use the scoped variants,
\code{impute_below_at}, and \code{impute_below_if}. To use \verb{_at} effectively,
you must know that \verb{_at`` affects variables selected with a character vector, or with }vars()`.
}
\examples{
# select variables starting with a particular string.
impute_mean_all(airquality)

impute_mean_at(airquality,
               .vars = c("Ozone", "Solar.R"))

\dontrun{
library(dplyr)
impute_mean_at(airquality,
                .vars = vars(Ozone))

impute_mean_if(airquality,
                .predicate = is.numeric)

library(ggplot2)
airquality \%>\%
  bind_shadow() \%>\%
  impute_mean_all() \%>\%
  add_label_shadow() \%>\%
  ggplot(aes(x = Ozone,
             y = Solar.R,
             colour = any_missing)) +
         geom_point()
}

}
