% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzipmed_package.R
\name{binoutzimed}
\alias{binoutzimed}
\title{Mediation Analysis for Zero-Inflated Count Mediators using MZIP (Binary or Count Outcome)}
\usage{
binoutzimed(
  outcome,
  mediator,
  exposure,
  confounder = NULL,
  C = NULL,
  n = 1000,
  X = 1,
  Xstar = 0,
  error = "Delta",
  robust = FALSE
)
}
\arguments{
\item{outcome}{is the binary or count outcome variable}

\item{mediator}{is the zero-inflated mediator variable, currently only 1 mediator variable is allowed}

\item{exposure}{is the primary exposure being considered, only 1 is allowed}

\item{confounder}{is a vector of confounder variables. If no confounder variables are needed then confounder is set to NULL. If more than 1 confounder is being considered then use the cbind function, e.g. cbind(var1,var2)}

\item{C}{is a vector for theoretical values of each confounder. By default each each value of C will be the mean value of each confounder.}

\item{n}{is the number of repetition if bootstrapped errors are used. Default is 1000}

\item{X}{is the theoretical value for the exposure variable to be set at. The default is to 1}

\item{Xstar}{is the theoretical value for the exposure variable to be compared to X. The default is 0, so direct, indirect, and proportion mediated values will be for a 1 unit increase in the exposure variable.}

\item{error}{='Delta' for delta method standard errors and ='Boot' for bootstrap. Default is delta method}

\item{robust}{indicates if a robust covariance matrix should be used for MZIP in delta method derivations. Default is FALSE.}
}
\value{
The function will return a list of 12 elements.
GLM is the results of regressing the mediator+exposure+confounder on the outcome using a Poisson model with robust standard errors \cr
MZIP is the results of regressing the exposure and confounders on the mediator using the MZIP model \cr
RRNDE is the risk ratio of the direct effect \cr
RRNIE is the risk ratio of the indirect effect. \cr
logRRNDEse is the standard error for the log risk ratio of NDE \cr
RRNDEci is the 95\% confidence interval for the direct effect risk ratio\cr
logRRNIEse is the standard error for  the indirect effect log risk ratio \cr
RRNIEci is the 95\% confidence interval for the indirect effect risk ratio \cr
RRTE is the total effect risk ratio \cr
logRRTEse is the standard error for the total effect log risk ratio\cr
RRTECI is the confidence interval for the total effect risk ratio \cr
PM is the proportion mediated
}
\description{
This function incorporates the MZIP model into the counterfactual approach to mediation analysis
as proposed by Vanderweele when the mediator is a Zero-Inflated count variable for cases with
binary or count outcome using a Poisson regression with robust standard errors. Standard Errors for
direct and indirect effects are computed using delta method or bootstrapping. Note: This function
assumes that the outcome is continuous and all exposure, mediator, outcome, and confounder variables
have the same sample size. Binary variables must be dummy coded prior.
A Poisson regression with robust standard errors were used to obtain direct and indirect
effect estimates on a risk ratio scale because odds ratios are a non-collapsible measure which
can cause issues in a mediation framework (see Vanderweele 2016).
}
\examples{
    #Example with delta method
    zimed=binoutzimed(outcome=mzipmed_data$binY,mediator=mzipmed_data$ziM,
                     exposure=mzipmed_data$X,confounder=cbind(mzipmed_data$C1,
                     mzipmed_data$C2),error="Delta",robust=FALSE,X=1,Xstar=0)

    \donttest{
    #Example using bootstrapping, 10 iterations are used for succinctness
    zimed2=binoutzimed(outcome=mzipmed_data$binY,mediator=mzipmed_data$ziM,
                   exposure=mzipmed_data$X,confounder=cbind(mzipmed_data$C1,
                   mzipmed_data$C2),error="Boot",n=10,C=c(0,0.5))
                   }
}
