% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PlotCorrelation.R
\name{PlotCorrelation}
\alias{PlotCorrelation}
\title{Plot the correlation between Phylostrata and Divergence-Strata
 of a given PhyloExpressionSet and DivergenceExpressionSet}
\usage{
PlotCorrelation(PhyloExpressionSet, DivergenceExpressionSet,
  method = "pearson", linearModel = FALSE, main.text = NULL, ...)
}
\arguments{
\item{PhyloExpressionSet}{a standard PhyloExpressionSet object.}

\item{DivergenceExpressionSet}{a standard DivergenceExpressionSet object.}

\item{method}{a character string specifying the correlation method to cbe used, e.g. "pearson", "kendall", "spearman".}

\item{linearModel}{a boolean value specifying whether a linear model should be
fitted to the data and furthermore, should be visualized in the corresponding plot.}

\item{main.text}{a character string specifying the text that shall be written as main.
Default is \code{main.text} = \code{NULL}.}

\item{\dots}{default plot parameters.}
}
\value{
a jitter-correlation-plot of PS and DS correlation.
}
\description{
This function plots the correlation coefficient between phylostratum values
and divergence-stratum values of a given PhyloExpressionSet and DivergenceExpressionSet.

This function can be used to test whether a given PS distribution and DS distribution are
linear correlated so that the independence of PS and DS can be assumed for
subsequent analyses (Quint et al., 2012).
}
\examples{
# read standard phylotranscriptomics data
 data(PhyloExpressionSetExample)
 data(DivergenceExpressionSetExample)

# plot the PS and DS correlation
PlotCorrelation(PhyloExpressionSetExample, DivergenceExpressionSetExample,
                method = "pearson", linearModel = TRUE,
                main.text = "Pearson's ")
}
\author{
Hajk-Georg Drost
}
\references{
Quint M et al. 2012. "A transcriptomic hourglass in plant embryogenesis". Nature (490): 98-101.
}
\seealso{
\code{\link{cor}}
}

