% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_mx_dataset.R
\name{new_mx_dataset}
\alias{new_mx_dataset}
\title{Constructor for mx_dataset object}
\usage{
new_mx_dataset(
  data = data.frame(),
  slide_id = character(),
  image_id = character(),
  marker_cols = vector(),
  metadata_cols = NULL
)
}
\arguments{
\item{data}{multiplexed data to normalize. Data assumed to be a data.frame with cell-level data.}

\item{slide_id}{String slide identifier of input \code{data}. This must be a column in the \code{data} data.frame.}

\item{image_id}{String image identifier of input \code{data}. This must be a column in the \code{data} data.frame.}

\item{marker_cols}{vector of column name(s) in \code{data} corresponding to marker values.}

\item{metadata_cols}{other identifiers of the input \code{data} (default=NULL). This must be a vector of column name(s) in the \code{data} data.frame.}
}
\value{
mx_dataset object with attributes \code{data} (data.frame), \code{slide_id} (character), \code{image_id} (character), \code{marker_cols} (vector), \code{metadata_cols} (default: NULL, otherwise vector).
}
\description{
Constructor for mx_dataset object
}
