% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funreg_utils.R
\name{impute_fpca}
\alias{impute_fpca}
\title{impute_fpca}
\usage{
impute_fpca(
  mxfundata,
  id,
  r = "r",
  value = "fundiff",
  knots = NULL,
  analysis_vars,
  smooth
)
}
\arguments{
\item{mxfundata}{Dataframe of spatial summary functions from multiplex imaging data, in long format. Can be estimated using the function \code{extract_summary_functions} or provided separately.}

\item{id}{Character string, the name of the variable that identifies each unique subject.}

\item{r}{Character string, the name of the variable that identifies the function domain (usually a radius for spatial summary functions). Default is "r".}

\item{value}{Character string, the name of the variable that identifies the spatial summary function values. Default is "fundiff".}

\item{knots}{Number of knots for defining spline basis.}

\item{analysis_vars}{Optional list of variables to be retained for downstream analysis.}

\item{smooth}{Option to smooth data using FPCA.}
}
\value{
A \code{dataframe} where the missing function values (NA) for the \code{value} variable have been replaced with estimates from FPCA.
}
\description{
Internal function called by \code{TITLE: regression function} that imputes missing data in functional predictors using FPCA.
}
\examples{
# simulate data
set.seed(1001)

}
\author{
Julia Wrobel \email{julia.wrobel@emory.edu}
}
\keyword{internal}
