% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ovarian_FDA}
\alias{ovarian_FDA}
\title{Multiplex imaging data from an ovarian cancer tumor microarray}
\format{
\subsection{\code{ovarian_FDA}}{

An mxFDA object with augmented ovarian cancer multiplex immunofluorescence data, and NN G(r) calculated:
\describe{
\item{Metadata}{information about the spatial samples with column \code{sample_key} column in both}
\item{Spatial}{cell-level information with \code{x} and \code{y} columns along with \code{sample_key} to link to \code{Metadata}}
\item{subject_key}{column in \code{Metadata} that may have multiple \code{sample_key} values for each, akin to patient IDs}
\item{sample_key}{column in both \code{Metadata} and \code{Spatial} that is a 1:1 with the samples (unique per sample)}
\item{univariate_summaries}{univariate summary slot with nearest neighbor G calculared}
\item{bivariate_summaries}{empty slot available for bivariate summaries}
\item{functional_pca}{empty slot for functional PCA data of summaries}
\item{functional_cox}{empty slot for functional models}
}
}
}
\source{
\url{https://bioconductor.org/packages/release/data/experiment/html/VectraPolarisData.html}
}
\usage{
ovarian_FDA
}
\description{
This data is adapted from the VectraPolarisData Bioconductor package and comes from a tumor-microarray of tissue samples from 128 patients with ovarian cancer.
There is one patient per subject.
}
\details{
Spatial summary functions of ovarian cancer multiplex imaging data.

This data is adapted from the VectraPolarisData Bioconductor package.
Signal between the survival outcome and spatial summary functions has been augmented for teaching purposes.
Spatial relationship is summarized using the nearest neighbor G function.
}
\keyword{datasets}
