% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_spatial_summary.R
\name{extract_spatial_summary}
\alias{extract_spatial_summary}
\title{Summarise spatial data in mxFDA object}
\usage{
extract_spatial_summary(mxFDAobject, columns, grouping_columns = NULL)
}
\arguments{
\item{mxFDAobject}{object of class \code{mxFDA}}

\item{columns}{character vector for column heading for cells to summarise}

\item{grouping_columns}{character vector of other columns to use as grouping, such as region classification column}
}
\value{
data frame with percent of total points per spatial sample \code{columns}.
If multiple levels are present in \code{columns} columns, multiple output columns will be provided.
}
\description{
Summarise spatial data in mxFDA object
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Currently this function is experimental as it only handles data that has text in the columns. Eventually,
will be able to handle any data inputs such as those from HALO where cells are designated as positive (1) or
negative (0) for a cell phenotypes.
}
\examples{
#load data
data(lung_df)

#create data frames for `mxFDA` object
clinical = lung_df \%>\%
  dplyr::select(image_id, patient_id, patientImage_id, gender,
         age, survival_days, survival_status, stage) \%>\%
  dplyr::distinct()
#make small, just need to make sure it runs
spatial = lung_df \%>\%
  dplyr::select(-image_id, -gender, -age, -survival_days, -survival_status, -stage) \%>\%
  dplyr::filter(patientImage_id \%in\% clinical$patientImage_id[1:10])

#create `mxFDA` object
mxFDAobject = make_mxfda(metadata = clinical,
                         spatial = spatial,
                         subject_key = "patient_id",
                         sample_key = "patientImage_id")

#get markers
markers = colnames(mxFDAobject@Spatial) \%>\%
  grep("pheno", ., value = TRUE)

#extract summary
df = extract_spatial_summary(mxFDAobject, markers)

}
\author{
Alex Soupir \email{alex.soupir@moffitt.org}
}
