% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-mwaved.R
\name{plot.waveletCoef}
\alias{plot.waveletCoef}
\title{Multi-Resolution Analysis plot of wavelet coefficients}
\usage{
\method{plot}{waveletCoef}(x, y = NULL, labels = NULL, ..., lowest = NULL,
  highest = NULL, scaling = 1, ggplot = TRUE)
}
\arguments{
\item{x}{A list of class waveletCoef.}

\item{y}{An optional numeric vector of trimmed wavelet coefficients to be overlayed on top of the plot for comparison with the \code{x} wavelet coefficients.}

\item{labels}{Optional character vector with two elements to give name labels to \code{x} and \code{y} respectively.}

\item{...}{Arguments to be passed to methods.}

\item{lowest}{Specifies the coarsest resolution to display in the Multi-resolution plot.}

\item{highest}{Specifies the finest resolution to display in the Multi-resolution plot.}

\item{scaling}{A numeric value that acts as a graphical scaling parameter to rescale the wavelet coefficients in the plot. A larger scaling value will reduce the size of the coefficients in the plot.}

\item{ggplot}{A logical value to specify if the user wants to use base graphics (FALSE) or ggplot2  graphics (TRUE).}
}
\description{
Plots the wavelet coefficient object in the multiresolution analysis
}
\seealso{
\code{\link{multiCoef}} for generating a list of class `waveletCoef`
}

