% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvgam_fevd-class.R
\name{summary.mvgam_fevd}
\alias{summary.mvgam_fevd}
\title{Posterior summary of forecast error variance decompositions}
\usage{
\method{summary}{mvgam_fevd}(object, probs = c(0.025, 0.975), ...)
}
\arguments{
\item{object}{an object of class \code{mvgam_fevd} obtained using the
\code{fevd()} function. This object will contain draws from the posterior
distribution of the forecast error variance decompositions.}

\item{probs}{The upper and lower percentiles to be computed by the \code{quantile} function,
in addition to the median}

\item{...}{ignored}
}
\value{
A long-format \code{tibble} reporting the posterior median,
upper and lower percentiles of the error variance decompositions of
each series at all horizons.
}
\description{
This function takes an \code{mvgam_fevd} object and
calculates a posterior summary of the error variance decompositions of each
series, at all horizons
}
\seealso{
\code{\link{fevd}}, \code{\link{plot.mvgam_fevd}}
}
\author{
Nicholas J Clark
}
