% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspWarning.R
\name{mspWarning}
\alias{mspWarning}
\title{Process Alarms}
\usage{
mspWarning(mspMonitor_object, faultsToTriggerAlarm = 5)
}
\arguments{
\item{mspMonitor_object}{An xts matrix returned by the mspMonitor() function}

\item{faultsToTriggerAlarm}{Specifies how many sequential faults will cause
an alarm to trigger. Defaults to 5.}
}
\value{
An xts matrix of the same dimensions as mspMonitor_object, with a
  recorded negative or positive and type-specific alarm status. Alarm codes
  are: 0 = no alarm, 1 = Hotelling's T2 alarm, 2 = Squared Prediction Error
  alarm, and 3 = both alarms.
}
\description{
Trigger an alarm, if necessary, for incoming multivariate
  process observations.
}
\details{
This function and the mspMonitor() function are designed to be ran
  via a scheduled task through Windows "Task Scheduler" or Macintosh OX
  "launchd" application suites. The file flow is as follows: at each time
  interval, run the mspMonitor() function on the matrix of daily observations
  to add a flag status to the most recent incoming observation in the matrix,
  and return this new xts matrix. Then, pass this updated daily observation
  matrix to the mspWarning() function, which will check if the process has
  recorded five or more sequential monitoring statistic flags in a row. Of
  note, because these functions are expected to be repeatedly called in real
  time, this function will only check for an alarm within the last row of the
  xts matrix. To check multiple rows for an alarm state, please use the
  mspTrain() function, which was designed to check multiple past
  observations.

  This function requires an xts matrix returned by the mspMonitor() function.
}
\examples{

\dontrun{# cut down on R CMD check time

  nrml <- mspProcessData(faults = "NOC")
  n <- nrow(nrml)

  # Calculate the training summary, but save five observations for monitoring.
  trainResults_ls <- mspTrain(data = nrml[1:(n - 5), -1],
                              labelVector = nrml[1:(n - 5), 1],
                              trainObs = 4320)

  # While training, we included 1 lag (the default), so we will also lag the
  #   observations we will test.
  testObs <- nrml[(n - 6):n, -1]
  testObs <- xts:::lag.xts(testObs, 0:1)
  testObs <- testObs[-1,]
  testObs <- cbind(nrml[(n - 5):n, 1], testObs)

  # Run the monitoring function.
  dataAndFlags <- mspMonitor(observations = testObs[, -1],
                             labelVector = testObs[, 1],
                             trainingSummary = trainResults_ls$TrainingSpecs)

  # Alarm check the last row of the matrix returned by the mspMonitor
  #   function
  mspWarning(dataAndFlags)

}

}
\seealso{
Pipe flow: \code{\link{mspTrain}} into \code{\link{mspMonitor}}
  into \code{mspWarning}.
}
