\name{mvMORPH-package}
\alias{mvMORPH-package}
\alias{mvMORPH}
\docType{package}
\title{
Multivariate Comparative Methods for Fitting Evolutionary Models to Morphometric Data
}
\description{
Fit of multivariate evolutionary models on trees (with one or multiple selective regimes) and time-series dedicated to morphometrics or biometric continuous data with covariation. Testing for a phylogenetic signal in a multivariate dataset (including fossil and/or extant taxa), fitting linear models to high-dimensional multivariate comparative data, changes in rate or mode of evolution of continuous traits, simulating multivariate traits evolution, computing the likelihood of multivariate models, accounts for measurement errors and missing data, and other things...
}
\details{
\tabular{ll}{
Package: \tab mvMORPH\cr
Type: \tab Package\cr
Version: \tab 1.1.8\cr
Date: \tab 2013-07-22\cr
License: \tab GPL (>=2.0)\cr
}
}
\author{
Julien Clavel

Maintainer: Julien Clavel <julien.clavel@hotmail.fr>
}
\references{
  Clavel et al. (2015). mvMORPH: an R package for fitting multivariate evolutionary models to morphometric data. Methods in Ecology and Evolution, 6(11):1311-1319. doi: 10.1111/2041-210X.12420.
  
  Clavel et al. (2019). A Penalized Likelihood framework for high-dimensional phylogenetic comparative methods and an application to new-world monkeys brain evolution. Systematic Biology 68(1): 93-116. doi: 10.1093/sysbio/syy045.

  Clavel & Morlon (2020). Reliable phylogenetic regressions for multivariate comparative data: illustration with the MANOVA and application to the effect of diet on mandible morphology in Phyllostomid bats. Systematic Biology 69(5): 927-943. doi: 10.1093/sysbio/syaa010
}
\keyword{ mvols }
\keyword{ mvgls }
\keyword{ manova }
\keyword{ pairwise tests }
\keyword{ OU }
\keyword{ BM }
\keyword{ EB }
\keyword{ Shifts }
\keyword{ Measurement error }
\keyword{ Simulations }
\keyword{ Evolutionary rates }
\keyword{ SIMMAP }
\seealso{
\code{\link{mvols}}
\code{\link{mvgls}}
\code{\link{mvgls.pca}}
\code{\link{mvgls.dfa}}
\code{\link{manova.gls}}
\code{\link{pairwise.glh}}
\code{\link{mvOU}}
\code{\link{mvBM}}
\code{\link{mvEB}}
\code{\link{mvSHIFT}}
\code{\link{mvOUTS}}
\code{\link{mvRWTS}}
\code{\link{mvSIM}}
\code{\link{mvLL}}
\code{\link{LRT}}
\code{\link{halflife}}
\code{\link{stationary}}
\code{\link{estim}}
\code{\link{aicw}}
\code{\link{GIC}}
\code{\link{EIC}}
\code{\link{mvqqplot}}
}



