% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{buildProgression}
\alias{buildProgression}
\title{Build Chord Progression}
\usage{
buildProgression(root = "A4", scale = "minor", play = FALSE,
  plot = FALSE, formatNotation = TRUE, ...)
}
\arguments{
\item{root}{String: Root note. Default = "A4"}

\item{scale}{String: "major" or "minor". Default = "minor"}

\item{play}{Logical: If TRUE, play scale using \link{playProgression}}

\item{plot}{Logical: If TRUE, plot each chord in the progression using \link{cplot.piano}}

\item{formatNotation}{Logical: If TRUE, format notes to include both flats and sharps
to avoid repeating the same letter. e.g. convert c("Gb4", "G4") to c("F#4", "G4")}

\item{...}{Additional arguments to be passed to \link{playProgression} if \code{ play = TRUE}}
}
\description{
Build Chord Progression
}
\examples{
buildProgression("C4", "minor")
buildProgression("Bb4", "major")
\dontrun{
buildProgression("Bb4", "major", play = TRUE, plot = TRUE)
}
}
\author{
Efstathios D. Gennatas
}
