% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_version_management.R
\name{lib.decide_version}
\alias{lib.decide_version}
\title{Choose correct package version, and print decision.}
\usage{
lib.decide_version(
  packVersion,
  lib_location,
  pick.last = FALSE,
  print_version_choice = TRUE,
  warn_for_major_diff = TRUE
)
}
\arguments{
\item{packVersion}{A named character vector with package names and their version indication (e.g. \code{c(dplyr = '>= 0.4.0', ggplot = '')}).}

\item{lib_location}{The location of the R_MV_library folder.}

\item{pick.last}{If a version like\code{>= 0.5} is given and multiple versions exist, a choice needs to be made.
By default it will take the first higher version (when it exists, just\code{0.5}, which is often the case).
This because this is most likely to not change the behavior of the code. Picking the latest version is most
compatible with matching other packages their dependencies (e.g. if a later package depends on this package but asks for\code{> 0.6}, it will crash).
The downside of this is that an update could be a major one, going from\code{0.5} to\code{2.0}, where allot of things can change and code is likely to not work anymore.}

\item{print_version_choice}{if true, it will print the choices it made.}

\item{warn_for_major_diff}{If true, the default, will return warnings if the loaded package is a major release higher then the package that was requested.}
}
\description{
Obtains the correct version based on the version instruction provided (e.g. \code{>= 0.5}). It will print which version is chosen if `verbose = TRUE`.
if no compatible version is found between the available versions, the function 'chooseVersion' will return an error to notify you.
}
