% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{resample.pvalue}
\alias{resample.pvalue}
\title{p-value via resampling}
\usage{
resample.pvalue(value, ...)
}
\arguments{
\item{value}{numeric, the value of (total-/m-)multivariance for which the p-value shall be computed}

\item{...}{passed to \code{\link{resample.multivariance}}. Required is the data matrix \code{x}.}
}
\value{
It returns 1 minus the value of the empirical distribution function of the resampling samples evaluated at the given value.
}
\description{
Use a resampling method to generate samples of the test statistic under the hypothesis of independence. Based on these the p.value of a given value of a test statistic is computed.
}
\details{
This function is useful if a p-value of a test statistic shall be computed based on the resampling values of the test statistic of a different sample. For the p-value based on the same sample \code{\link{resample.multivariance}(...)$p.value} is sufficient.
}
\examples{
x = coins(100)
resample.pvalue(multivariance(x),x=x,times = 300)
resample.pvalue(multivariances.all(x),x=x,times = 300,type = "all")

}
\references{
For the theoretic background see the reference [3] given on the main help page of this package: \link{multivariance-package}.
}
