% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{multivariance.timing}
\alias{multivariance.timing}
\title{estimate of the computation time}
\usage{
multivariance.timing(N = NULL, n, sectime = NULL, coef.cdm = 15.2,
  coef.prod = 2.1, coef.sum = 1.05, determine.parameters = FALSE)
}
\arguments{
\item{N}{number of samples. If \code{NULL} and \code{sectime} is given, then \code{N} is computed.}

\item{n}{number of variables}

\item{sectime}{desired computation time in seconds. If \code{NULL} then the required computation time is computed.}

\item{coef.cdm}{computation time parameter for the centered distance matrices}

\item{coef.prod}{computation time parameter for matrix products}

\item{coef.sum}{computation time parameter for matrix sums}

\item{determine.parameters}{if \code{TRUE} then the parameters for the current computer are determined. This might take a while (3 loops to N=1000).}
}
\description{
Estimates the computation time. This is relative rough. First run with \code{determine.parameters = TRUE} (which takes a while). Then use the computed parameters to determine the computation time/or sample size.
}
\details{
When detecting the parameters, the median of the computation times is used.
}
\examples{
Ns = (1:100)*10
ns = 1:100
fulltime = outer(Ns,ns,FUN = function(N,n) multivariance.timing(N,n))
contour(Ns,ns,fulltime,xlab = "N",ylab = "n",
 main = "computation time of multivariance in secs",
 sub = "using default parameters -
 use 'determine.parameters = TRUE' to compute machine specific values")

# Run to determine the parameters of your system:
# multivariance.timing(determine.parameters = TRUE)

}
