% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.multipanelfigure}
\alias{print.multipanelfigure}
\title{Print a multi-panel figure}
\usage{
\method{print}{multipanelfigure}(x, newpage = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{multipanelfigure}.}

\item{newpage}{Logical. If \code{TRUE}, a new device page is opened before
drawing.}

\item{...}{Passed from other print methods.}
}
\value{
The input \code{x} is invisibly returned, but the method is mostly
invoked for the side effect of printing the plot to the current device.
}
\description{
Prints and object of class \code{multipanelfigure}.
}
\examples{
p <- lattice::xyplot(dist ~ speed, cars)
figure <- multi_panel_figure(
  width = 100, height = 100,
  rows = 1, columns = 1
)
# With no panels, printing shows the layout
print(figure)
figure <- fill_panel(figure, p)
# After a panel is added, printing shows the plot.
print(figure) # shows plot
}
\references{
Graumann, J., and Cotton, R.J. (2018). multipanelfigure: Simple
Assembly of Multiple Plots and Images into a Compound Figure. Journal of
Statistical Software 84. doi: 10.18637/jss.v084.c03
}
