// Generated by rstantools.  Do not edit by hand.

/*
    multinma is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    multinma is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with multinma.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_predict_delta_new_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_predict_delta_new");
    reader.add_event(17, 15, "end", "model_predict_delta_new");
    return reader;
}
#include <stan_meta_header.hpp>
class model_predict_delta_new
  : public stan::model::model_base_crtp<model_predict_delta_new> {
private:
        int nt;
        matrix_d RE_cor;
        matrix_d RE_L;
public:
    model_predict_delta_new(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_predict_delta_new(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_predict_delta_new_namespace::model_predict_delta_new";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "nt", "int", context__.to_vec());
            nt = int(0);
            vals_i__ = context__.vals_i("nt");
            pos__ = 0;
            nt = vals_i__[pos__++];
            check_greater_or_equal(function__, "nt", nt, 1);
            current_statement_begin__ = 3;
            validate_non_negative_index("RE_cor", "(nt - 1)", (nt - 1));
            validate_non_negative_index("RE_cor", "(nt - 1)", (nt - 1));
            context__.validate_dims("data initialization", "RE_cor", "matrix_d", context__.to_vec((nt - 1),(nt - 1)));
            RE_cor = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((nt - 1), (nt - 1));
            vals_r__ = context__.vals_r("RE_cor");
            pos__ = 0;
            size_t RE_cor_j_2_max__ = (nt - 1);
            size_t RE_cor_j_1_max__ = (nt - 1);
            for (size_t j_2__ = 0; j_2__ < RE_cor_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < RE_cor_j_1_max__; ++j_1__) {
                    RE_cor(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            stan::math::check_corr_matrix(function__, "RE_cor", RE_cor);
            // initialize transformed data variables
            current_statement_begin__ = 6;
            validate_non_negative_index("RE_L", "(nt - 1)", (nt - 1));
            validate_non_negative_index("RE_L", "(nt - 1)", (nt - 1));
            RE_L = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((nt - 1), (nt - 1));
            stan::math::fill(RE_L, DUMMY_VAR__);
            stan::math::assign(RE_L,cholesky_decompose(RE_cor));
            // execute transformed data statements
            // validate transformed data
            current_statement_begin__ = 6;
            stan::math::check_cholesky_factor_corr(function__, "RE_L", RE_L);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 9;
            validate_non_negative_index("d", "(nt - 1)", (nt - 1));
            num_params_r__ += (nt - 1);
            current_statement_begin__ = 10;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_predict_delta_new() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 9;
        if (!(context__.contains_r("d")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable d missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("d");
        pos__ = 0U;
        validate_non_negative_index("d", "(nt - 1)", (nt - 1));
        context__.validate_dims("parameter initialization", "d", "vector_d", context__.to_vec((nt - 1)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> d((nt - 1));
        size_t d_j_1_max__ = (nt - 1);
        for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
            d(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(d);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable d: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 10;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "tau", "double", context__.to_vec());
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 9;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> d;
            (void) d;  // dummy to suppress unused var warning
            if (jacobian__)
                d = in__.vector_constrain((nt - 1), lp__);
            else
                d = in__.vector_constrain((nt - 1));
            current_statement_begin__ = 10;
            local_scalar_t__ tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.scalar_lb_constrain(0, lp__);
            else
                tau = in__.scalar_lb_constrain(0);
            // model body
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("d");
        names__.push_back("tau");
        names__.push_back("delta_new");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((nt - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nt - 1));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_predict_delta_new_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> d = in__.vector_constrain((nt - 1));
        size_t d_j_1_max__ = (nt - 1);
        for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
            vars__.push_back(d(j_1__));
        }
        double tau = in__.scalar_lb_constrain(0);
        vars__.push_back(tau);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 14;
            validate_non_negative_index("delta_new", "(nt - 1)", (nt - 1));
            Eigen::Matrix<double, Eigen::Dynamic, 1> delta_new((nt - 1));
            stan::math::initialize(delta_new, DUMMY_VAR__);
            stan::math::fill(delta_new, DUMMY_VAR__);
            stan::math::assign(delta_new,multi_normal_cholesky_rng(d, multiply(tau, RE_L), base_rng__));
            // validate, write generated quantities
            current_statement_begin__ = 14;
            size_t delta_new_j_1_max__ = (nt - 1);
            for (size_t j_1__ = 0; j_1__ < delta_new_j_1_max__; ++j_1__) {
                vars__.push_back(delta_new(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_predict_delta_new";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t d_j_1_max__ = (nt - 1);
        for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "d" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t delta_new_j_1_max__ = (nt - 1);
        for (size_t j_1__ = 0; j_1__ < delta_new_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta_new" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t d_j_1_max__ = (nt - 1);
        for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "d" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t delta_new_j_1_max__ = (nt - 1);
        for (size_t j_1__ = 0; j_1__ < delta_new_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta_new" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_predict_delta_new_namespace::model_predict_delta_new stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
