% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_dic.R
\name{dic}
\alias{dic}
\title{Deviance Information Criterion (DIC)}
\usage{
dic(x, ...)
}
\arguments{
\item{x}{A fitted model object, inheriting class \link{stan_nma}}

\item{...}{Other arguments (not used)}
}
\value{
A \link{nma_dic} object.
}
\description{
Calculate the DIC for a model fitted using the \code{\link[=nma]{nma()}} function.
}
\examples{
## Smoking cessation
\donttest{
# Run smoking FE NMA example if not already available
if (!exists("smk_fit_FE")) example("example_smk_fe")
}
\donttest{
# Run smoking RE NMA example if not already available
if (!exists("smk_fit_RE")) example("example_smk_re")
}
\donttest{
# Compare DIC of FE and RE models
(smk_dic_FE <- dic(smk_fit_FE))
(smk_dic_RE <- dic(smk_fit_RE))   # substantially better fit

# Plot residual deviance contributions under RE model
plot(smk_dic_RE)

# Check for inconsistency using UME model
}
\donttest{
# Run smoking UME NMA example if not already available
if (!exists("smk_fit_RE_UME")) example("example_smk_ume")
}
\donttest{
# Compare DIC
smk_dic_RE
(smk_dic_RE_UME <- dic(smk_fit_RE_UME))  # no difference in fit

# Compare residual deviance contributions
plot(smk_dic_RE, smk_dic_RE_UME, show_uncertainty = FALSE)
}
}
\seealso{
\code{\link[=print.nma_dic]{print.nma_dic()}} for printing details, \code{\link[=plot.nma_dic]{plot.nma_dic()}} for
producing plots of residual deviance contributions.
}
