% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_table.R
\name{mc_table}
\alias{mc_table}
\title{Generate tables with summarized GRAID counts (WIP)}
\usage{
mc_table(data, by = "all", format = "wide", write = FALSE,
  writeto = getwd(), output = "tex")
}
\arguments{
\item{data}{A \code{\link[data.table]{data.table}} in multicastR format.}

\item{by}{Character. \code{"all"} places all data in one table,
\code{"corpus"} generates one table for each corpus, and \code{"text"} one
table for each text.}

\item{format}{Unused. Will be used to select between \code{"wide"} and
\code{"long"} table layouts.}

\item{write}{Logical. If \code{TRUE}, writes output to file.}

\item{writeto}{A directory to which to write output. Defaults to
\code{getwd}. Ignored if \code{write} is \code{FALSE}.}

\item{output}{Unused. Will be used to specify the file format to write as.
Currently only TEX output is supported.}
}
\value{
A \code{data.table} with GRAID counts.
}
\description{
Constructs simple tables with counts for certain combinations of GRAID form,
person/animacy, and function symbols. In its current form, the GRAID
categories counted for the tables are predetermined and cannot be changed by
the user. The TEX files that can optionally be written by this function are
used for the 'Corpus counts' in the Multi-CAST documentation.
}
\examples{
\dontrun{
  # generate a summary table for the entire collection
  mc <- multicast()
  mc_table(mc)

  # generate a summary table for the English corpus
  mc_table(mc[corpus == "english", ])
}
}
