% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised.R
\name{gpa}
\alias{gpa}
\title{Generalized Procrustes Analysis - GPA}
\usage{
gpa(X, graph = FALSE, ...)
}
\arguments{
\item{X}{\code{list} of input blocks.}

\item{graph}{\code{logical} indicating if decomposition should be plotted.}

\item{...}{additional arguments for RGCCA approach.}
}
\value{
\code{multiblock} object including relevant scores and loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a wrapper for the \code{FactoMineR::GPA} function for computing GPA.
}
\details{
GPA is a generalisation of Procrustes analysis, where one matrix is scaled and
rotated to be as similar as possible to another one. Through the generalisation, individual
scaling and rotation of each input matrix is performed against a common
representation which is estimated in an iterative manner.
}
\examples{
data(potato)
potList <- as.list(potato[c(1,2,9)])
pot.gpa    <- gpa(potList)
plot(scores(pot.gpa), labels="names")

}
\references{
Gower, J. C. (1975). Generalized procrustes analysis. Psychometrika. 40: 33–51.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
