% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corTestDf.R
\name{corTestDf}
\alias{corTestDf}
\title{Compute correlations and test their statistical significance}
\usage{
corTestDf(X, method = "p", use = "everything", ...)
}
\arguments{
\item{X}{Data matrix with selected variables.}

\item{method}{A type of correlation coefitient to be calculated, see function \code{cor}.}

\item{use}{In the case of missing values, which method should be used, see function \code{cor}.}

\item{\dots}{Arguments passed to other functions, see \code{cor.test}.}
}
\value{
A list with the following elements:
\itemize{
\item \code{cor} - correlation matrix.
\item \code{p} - a matrix of \eqn{p}-values.
\item \code{n} - a matrix of corresponding sample sizes.
}
}
\description{
The function computes the whole correlation matrix and corresponding sample sizes and \eqn{p}-values.
}
\examples{
corTestDf(mtcars[, 3:5])
}
\seealso{
\code{cor.test}
}
\author{
Aleš Žiberna
}
