% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compLoad.R
\name{compLoad}
\alias{compLoad}
\title{Compare factor loadings}
\usage{
compLoad(L1, L2)
}
\arguments{
\item{L1}{First set of factor loadings in a matrix form (variables are organized in rows and factors are organized in columns).}

\item{L2}{Second set of factor loadings in a matrix form (variables are organized in rows and factors are organized in columns).}
}
\value{
A list with the following elements:
\itemize{
\item \code{err} - Sum of squared differences between the values of \code{L1} and \code{L2} (for the corresponding permuation and signs).
\item \code{perm} - Permuation of columns of \code{L1} that results in the lowest \code{err} value.
\item \code{sign} - Signs of factor loadings of \code{L1}. The first value corresponds to the first column of \code{L1} and the second value corresponds to the second column of \code{L1}.
}
}
\description{
The function compares two sets of factor loadings by considering different possible orders of factors and different possible signs of factor loadings.
}
\examples{
L1 <- cbind(c(0.72, 0.81, 0.92, 0.31, 0.22, 0.15), c(0.11, 0.09, 0.17, 0.77, 0.66, 0.89))
L2 <- cbind(c(-0.13, -0.08, -0.20, -0.78, -0.69, -0.88), c(0.72, 0.82, 0.90, 0.29, 0.20, 0.17))
compLoad(L1, L2)
}
\author{
Aleš Žiberna and Friedrich Leisch (permutations)
}
