% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixLOR.R
\name{matrixLOR}
\alias{matrixLOR}
\title{Creating A Probability Matrix With Specified Local Odds Ratios}
\usage{
matrixLOR(x)
}
\arguments{
\item{x}{a square matrix with positive entries that describes the desired
local odds ratios matrix.}
}
\value{
Returns a square probability matrix that satisfies the local odds
ratios structure defined by \code{x}.
}
\description{
Utility function to create a square probability matrix that satisfies the
specified local odds ratios structure.
}
\details{
It is designed to ease the construction of the argument \code{LORterm}
in the \link{nomLORgee} and \link{ordLORgee} functions.
}
\section{Warning}{
 Caution is needed for local odds ratios close to zero.
}

\examples{
## Illustrating the construction of a "fixed" local odds ratios structure
## using the arthritis dataset. Here, we assume a uniform local odds ratios
## structure equal to 2 for each time pair.

## Create the uniform local odds ratios structure.
lorterm <- matrixLOR(matrix(2, 4, 4))

## Create the LORterm argument.
lorterm <- c(lorterm)
lorterm <- matrix(c(lorterm), 3, 25, TRUE)

## Fit the marginal model.
data(arthritis)
fitmod <- ordLORgee(y ~ factor(trt) + factor(time) + factor(baseline),
  data = arthritis, id = id, repeated = time, LORstr = "fixed",
  LORterm = lorterm)
fitmod

}
\seealso{
\link{nomLORgee} and \link{ordLORgee}.
}
\author{
Anestis Touloumis
}
