% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardSimplex_Dirichlet.R
\docType{class}
\name{standardSimplex_Dirichlet-class}
\alias{standardSimplex_Dirichlet-class}
\alias{standardSimplex_Dirichlet}
\title{An S4 class to represent the function \eqn{\prod_{i=1}^{n}x_i^{v_i-1}(1 - x_1 - \ldots - x_n)^{v_{n+1}-1}} on \eqn{T_n}}
\description{
Implementation of the function
\deqn{f \colon T_n \to (0,\infty),\, \vec{x} \mapsto f(\vec{x}) = \prod_{i=1}^{n}x_i^{v_i-1}(1 - x_1 - \ldots - x_n)^{v_{n+1}-1},}
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{T_n = \{\vec{x} \in \R^n : x_i\geq 0, \Vert \vec{x} \Vert_1 \leq 1\}} and \eqn{v_i>0}, \eqn{i=1,\ldots,n+1}, are constants.
The integral is known to be
\deqn{\int_{T_n} f(\vec{x}) d\vec{x} = \frac{\prod_{i=1}^{n+1}\Gamma(v_i)}{\Gamma(\sum_{i=1}^{n+1}v_i)},}
where \eqn{v_i>0} for \eqn{i=1,\ldots,n+1}.
}
\details{
The instance needs to be created with two parameters representing the dimension \eqn{n} and the vector of positive parameters.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}

\item{\code{v}}{A vector of dimension \eqn{n+1} with positive entries representing the constants}
}}

\examples{
n <- as.integer(3)
f <- new("standardSimplex_Dirichlet",dim=n,v=c(1,2,3,4))
}
