% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataExtraction_mtc.R
\name{create_mtc_device_from_dmtcd}
\alias{create_mtc_device_from_dmtcd}
\title{Create MTCDevice class from Delimited MTC Data and log file}
\usage{
create_mtc_device_from_dmtcd(file_path_dmtcd, file_path_xml, device_name,
  mtconnect_version = NULL)
}
\arguments{
\item{file_path_dmtcd}{Path to Delimited MTC Data file}

\item{file_path_xml}{Path to the XML file}

\item{device_name}{Name of the device in the xml. List of all the devices and their
names can be got using the \code{\link{get_device_info_from_xml}} function}

\item{mtconnect_version}{Specify MTConnect Version manually. If not specified, it is inferred automatically from the data.}
}
\description{
Create MTCDevice class from Delimited MTC Data and log file
}
\examples{
file_path_dmtcd = "testdata/dataExtraction/test_dmtcd.log"
file_path_xml = "testdata/dataExtraction/test_devices.xml"
device_name = "test_device"
mtc_device = create_mtc_device_from_dmtcd(
  system.file(file_path_dmtcd, package = "mtconnectR"),
  system.file(file_path_xml, package = "mtconnectR"),
  device_name)
print(summary(mtc_device))
}
