% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.covs.R
\name{expand.covs}
\alias{expand.covs}
\alias{expand.covs.default}
\title{Expand covariates in competing risks dataset in stacked format}
\usage{
expand.covs(data, ...)
}
\arguments{
\item{data}{An object of class \code{"msdata"}, such as output by
\code{\link{msprep}}}

\item{...}{Further arguments to be passed to or from other methods. They
are ignored in this function.}
}
\value{
An data frame object of the same class as the data argument,
containing the design matrix for the type-specific covariates, either on its
own (\code{append}=\code{FALSE}) or appended to the data
(\code{append}=\code{TRUE}).
}
\description{
Given a competing risks dataset in stacked format, and one or more
covariates, this function adds type-specific covariates to the dataset. The
original dataset with the type-specific covariates appended is returned.
}
\details{
Type-specific covariates can be used to analyse separate effects on all
event types in a single analysis based on a stacked data set (Putter, Fiocco
& Geskus (2007) and Geskus (2016)). It is only unambiguously defined for
numeric covariates or for explicit codings. Rows that contain the data for
that specific event type have the value copied from the original covariate
in case it is numeric. In all other rows it has the value zero. If the
covariate is a factor, it will be expanded on the design matrix given by
\code{\link[stats:model.matrix]{model.matrix}}. For standard "treatment
contrasts" this means that dummy variables are created.  If the covariate is
a factor, the column name combines the name of the covariate with the
specific event type. If \code{longnames}=\code{TRUE}, both parts are
intersected by the specific labels in the coding. Missing values in the
basic covariates are allowed and result in missing values in the expanded
covariates.
}
\examples{

# small data set in stacked format
tg <- data.frame(time=c(5,5,1,1,9,9),status=c(1,0,2,2,0,1),failcode=rep(c("I","II"),3),
        x1=c(1,1,2,2,2,2),x2=c(3,3,2,2,1,1))
tg$x1 <- factor(tg$x1,labels=c("male","female"))
# expanded covariates
expand.covs(tg,covs=c("x1","x2"))
expand.covs(tg,covs=c("x1","x2"),longnames=TRUE)
expand.covs(tg,covs=c("x1","x2"),append=FALSE)

}
\references{
Putter H, Fiocco M, Geskus RB (2007). Tutorial in biostatistics:
Competing risks and multi-state models. \emph{Statistics in Medicine}
\bold{26}, 2389--2430.

Geskus, Ronald B. (2016). \emph{Data Analysis with Competing Risks and
Intermediate States.} CRC Press, Boca Raton.
}
\seealso{
\code{\link{expand.covs.msdata}}.
}
\author{
Ronald Geskus and Hein Putter \email{H.Putter@lumc.nl}
}
\keyword{datagen}
