% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mread.R
\name{mread}
\alias{mread}
\alias{mread_cache}
\alias{mread_file}
\title{Read a model specification file}
\usage{
mread(model, project = getwd(), code = NULL, file = NULL, udll = TRUE,
  ignore.stdout = TRUE, raw = FALSE, compile = TRUE, audit = TRUE,
  quiet = getOption("mrgsolve_mread_quiet", FALSE), check.bounds = FALSE,
  warn = TRUE, soloc = tempdir(), preclean = FALSE, ...)

mread_cache(model = NULL, project = getwd(), file = paste0(model, ".cpp"),
  code = NULL, soloc = tempdir(), quiet = FALSE, preclean = FALSE, ...)

mread_file(file, ...)
}
\arguments{
\item{model}{model name}

\item{project}{location of the model specification file an any 
headers to be included}

\item{code}{a character string with model specification code to be 
used instead of a model file}

\item{file}{the full file name (with extension, but without path)
where the model is specified}

\item{udll}{use unique name for shared object}

\item{ignore.stdout}{passed to system call for compiling model}

\item{raw}{if TRUE, return a list of raw output}

\item{compile}{logical; if \code{TRUE}, the model will be built}

\item{audit}{check the model specification file for errors}

\item{quiet}{don't print messages when compiling}

\item{check.bounds}{check boundaries of parameter list}

\item{warn}{logical; if \code{TRUE}, print warning messages that may arise}

\item{soloc}{directory where model shared object is stored}

\item{preclean}{logical; if \code{TRUE}, compilation artifacts are 
cleaned up first}

\item{...}{passed along}
}
\description{
\code{mread} reads and parses a \code{mrgsolve} model 
specification file, builds the model, and returns 
a model object for simulation.
}
\details{
The \code{model} argument is required.  For typical use, 
the \code{file} argument is omitted and the value 
for \code{file} is generated from the value for \code{model}.
To determine the source file name, \code{mrgsolve} will look for 
a file extension in the value of \code{model}.  A file extension is 
assumed when it find sa period followed by one to three alpha-numeric 
characters at the end of the string (e.g. \code{mymodel.txt} but not 
\code{my.model}).  If no file extension is found, the extension \code{.cpp} 
is assumed (e.g. \code{file} is \code{<model-name>.cpp}).  If a file 
extension is found, \code{file} is \code{<model-name>}.    

Best practice is to avoid using \code{.} in \code{model} unless
you are using \code{model} to point to the model specification 
file name. Otherwise, use \code{\link{mread_file}}.
}
\section{Model Library}{


\code{mrgsolve} comes bundled with several precoded PK, PK/PD, and 
other systems models that are accessible via the \code{mread} interface.  

Models available in the library include:

\itemize{
  \item PK models: \code{pk1cmt}, \code{pk2cmt}, \code{pk3cmt},
                   \code{pk1}, \code{pk2}, \code{popex}, \code{tmdd}
  \item PKPD models: \code{irm1}, \code{irm2}, \code{irm3}, \code{irm4},
                      \code{emax}, \code{effect}
  \item Other models: \code{viral1}, \code{viral2}
}

When the library model is accessed, \code{mrgsolve} will compile and load
the model as you would for any other model.  It is only necessary to 
reference the correct model name and point the \code{project} argument
to the \code{mrgsolve} model library location via \code{\link{modlib}}.

For more details, see \code{\link{modlib_pk}}, \code{\link{modlib_pkpd}}, 
\code{\link{modlib_tmdd}}, \code{\link{modlib_viral}}, and 
\code{\link{modlib_details}} for more information about the state 
variables and parameters in each model.
}

\examples{

\dontrun{
code <- '
$PARAM CL = 1, VC = 5
$CMT CENT
$ODE dxdt_CENT = -(CL/VC)*CENT;
'

mod <- mcode("ex_mread", code)

mod

mod \%>\% init(CENT=1000) \%>\% mrgsim \%>\% plot


mod <- mread("irm3", modlib())

mod

# if the model is in the file mymodel.cpp
mod <- mread("mymodel")

# if the model is in the file mymodel.txt
mod <- mread(file = "mymodel.txt")

or

mod <- mread_file("mymodel.txt")


}

}
\seealso{
\code{\link{mcode}}, \code{\link{mcode_cache}}
}
