% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\docType{methods}
\name{init}
\alias{init}
\alias{init,mrgmod-method}
\alias{init,mrgsims-method}
\alias{init,missing-method}
\alias{init,list-method}
\alias{init,ANY-method}
\alias{as.init}
\alias{as.init,list-method}
\alias{as.init,numeric-method}
\alias{as.init,cmt_list-method}
\alias{as.init,missing-method}
\alias{as.init,NULL-method}
\alias{show,cmt_list-method}
\title{Methods for working with the model compartment list}
\usage{
init(.x, ...)

\S4method{init}{mrgmod}(.x, .y = list(), ..., .pat = "*")

\S4method{init}{mrgsims}(.x, ...)

\S4method{init}{missing}(.x, ...)

\S4method{init}{list}(.x, ...)

\S4method{init}{ANY}(.x, ...)

as.init(.x, ...)

\S4method{as.init}{list}(.x, ...)

\S4method{as.init}{numeric}(.x, ...)

\S4method{as.init}{cmt_list}(.x, ...)

\S4method{as.init}{missing}(.x, ...)

\S4method{as.init}{`NULL`}(.x, ...)

\S4method{show}{cmt_list}(object)
}
\arguments{
\item{.x}{the model object}

\item{...}{passsed along}

\item{.y}{list to be merged into parameter list}

\item{.pat}{a regular expression (character) to be applied as 
a filter when printing compartments to the screen}

\item{object}{to show}
}
\value{
an object of class \code{cmt_list} (see 
\code{\link{numericlist}})
}
\description{
Calling \code{init} with the model object as the first argument 
will return the model initial conditions as a \code{numericlist} 
object. See \code{\link{numericlist}} for methods to  deal with 
\code{cmt_list} objects.
}
\details{
Can be used to either get a compartment list object from a 
\code{mrgmod} model object or to update the compartment initial 
conditions in a model object.  For both uses, the return value 
is a \code{cmt_list} object. For the former use, \code{init} 
is usually called to print the compartment initial conditions 
to the screen, but the \code{cmt_list} object can also be coreced 
to a list or numeric R object.
}
\examples{
## example("init")
mod <- mrgsolve:::house()

init(mod)
init(mod, .pat="^C") ## may be useful for large models

class(init(mod))

init(mod)$CENT

as.list(init(mod))
as.data.frame(init(mod))
}
